/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.prefab.Utils;
import com.prefab.gui.GuiUtils;
import com.prefab.gui.controls.ExtendedButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CustomButton
extends ExtendedButton {
    private final ResourceLocation buttonTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_button.png");
    private final ResourceLocation buttonTexturePressed = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_button_pressed.png");
    private final ResourceLocation buttonTextureHover = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/prefab_button_highlight.png");

    public CustomButton(int xPos, int yPos, Component displayString, Button.OnPress handler) {
        super(xPos, yPos, 200, 90, displayString, handler, null);
    }

    public CustomButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
        super(xPos, yPos, width, height, displayString, handler, null);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            ResourceLocation buttonTexture = this.isHovered ? this.buttonTextureHover : this.buttonTexture;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)buttonTexture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            GuiUtils.bindAndDrawScaledTexture(buttonTexture, guiGraphics, this.getX(), this.getY(), this.width, this.height, 90, 20, 90, 20);
            int color = 0xE0E0E0;
            Component buttonText = this.getMessage();
            int strWidth = mc.font.width((FormattedText)buttonText);
            int ellipsisWidth = mc.font.width("...");
            if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
                buttonText = Utils.createTextComponent(mc.font.substrByWidth((FormattedText)buttonText, this.width - 6 - ellipsisWidth).getString() + "...");
            }
            guiGraphics.drawCenteredString(mc.font, buttonText, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
            guiGraphics.flush();
        }
    }
}

