/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.gui;

import com.prefab.Tuple;
import com.prefab.Utils;
import com.prefab.blocks.FullDyeColor;
import com.prefab.gui.GuiLangKeys;
import com.prefab.gui.GuiUtils;
import com.prefab.gui.controls.CustomButton;
import com.prefab.gui.controls.ExtendedButton;
import com.prefab.gui.controls.GuiCheckBox;
import com.prefab.gui.controls.GuiSlider;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiBase
extends Screen {
    private final ResourceLocation backgroundTextures = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/default_background.png");
    private final ResourceLocation narrowPanelTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/custom_background.png");
    private final ResourceLocation leftPanelTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/custom_left_panel.png");
    private final ResourceLocation middlePanelTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/custom_middle_panel.png");
    private final ResourceLocation rightPanelTexture = ResourceLocation.tryBuild((String)"prefab", (String)"textures/gui/custom_right_panel.png");
    protected int modifiedInitialXAxis = 0;
    protected int modifiedInitialYAxis = 0;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    protected int textColor = Color.DARK_GRAY.getRGB();

    public GuiBase(String title) {
        super((Component)Utils.createTextComponent(title));
    }

    public void init() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.width / 2;
    }

    protected int getCenteredYAxis() {
        return this.height / 2;
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(guiGraphics, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(guiGraphics, x, y);
        this.postButtonRender(guiGraphics, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text) {
        return this.createAndAddButton(x, y, width, height, text, true);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, GuiLangKeys.translateToComponent(text), this::buttonClicked, label);
        return (ExtendedButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate, String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked, label);
        return (ExtendedButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked, null);
        return (ExtendedButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(x, y, width, height, text, true);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text, boolean translate) {
        CustomButton returnValue = new CustomButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        return (CustomButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddDyeButton(int x, int y, int width, int height, DyeColor color, @Nullable String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)Utils.createTextComponent(GuiLangKeys.translateDye(color)), this::buttonClicked, label);
        return (ExtendedButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddFullDyeButton(int x, int y, int width, int height, FullDyeColor color, @Nullable String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)Utils.createTextComponent(GuiLangKeys.translateFullDye(color)), this::buttonClicked, label);
        return (ExtendedButton)this.addRenderableWidget((GuiEventListener)returnValue);
    }

    public GuiCheckBox createAndAddCheckBox(int xPos, int yPos, String displayString, boolean isChecked, GuiCheckBox.IPressable handler) {
        GuiCheckBox checkBox = new GuiCheckBox(xPos, yPos, GuiLangKeys.translateString(displayString), isChecked, handler);
        return (GuiCheckBox)this.addRenderableWidget((GuiEventListener)checkBox);
    }

    public GuiSlider createAndAddSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal) {
        GuiSlider slider = new GuiSlider(xPos, yPos, width, height, CommonComponents.EMPTY, minVal, maxVal, currentVal);
        return (GuiSlider)this.addRenderableWidget((GuiEventListener)slider);
    }

    protected void drawControlPanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.narrowPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlBackground(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindAndDrawScaledTexture(this.backgroundTextures, guiGraphics, grayBoxX, grayBoxY, width, height, width, height, width, height);
    }

    protected void drawControlLeftPanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.leftPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlMiddlePanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.middlePanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlRightPanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.rightPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawStandardControlBoxAndImage(GuiGraphics guiGraphics, ResourceLocation imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, x, y, 0.0f);
        this.drawControlBackground(guiGraphics, x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawTexture(imageLocation, guiGraphics, imagePos, y + 5, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (GuiEventListener button : this.children()) {
            if (!(button instanceof AbstractWidget)) continue;
            AbstractWidget currentButton = (AbstractWidget)button;
            if (!currentButton.visible) continue;
            currentButton.render(guiGraphics, mouseX, mouseY, (float)this.getMinecraft().getFrameTimeNs());
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public void drawString(GuiGraphics guiGraphics, String text, float x, float y, int color) {
        guiGraphics.drawWordWrap(this.font, (FormattedText)Utils.createTextComponent(text), (int)x, (int)y, 9999, color);
    }

    public void drawSplitString(GuiGraphics guiGraphics, String str, int x, int y, int wrapWidth, int textColor) {
        guiGraphics.drawWordWrap(this.font, (FormattedText)Utils.createTextComponent(str), x, y, wrapWidth, textColor);
    }

    public List<FormattedCharSequence> getSplitString(String str, int wrapWidth) {
        return this.getFontRenderer().split((FormattedText)Utils.createTextComponent(str), wrapWidth);
    }

    public List<FormattedCharSequence> getSplitString(FormattedText str, int wrapWidth) {
        return this.getFontRenderer().split(str, wrapWidth);
    }

    public void closeScreen() {
        this.getMinecraft().setScreen(null);
    }

    @NotNull
    public Minecraft getMinecraft() {
        assert (this.minecraft != null);
        return this.minecraft;
    }

    public Font getFontRenderer() {
        return this.getMinecraft().font;
    }

    public abstract void buttonClicked(AbstractButton var1);

    protected abstract void preButtonRender(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    protected abstract void postButtonRender(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);
}

