/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.config;

import com.prefab.config.ChestOptions;
import com.prefab.config.StarterHouseOptions;
import com.prefab.config.StrictModeOptions;
import com.prefab.structures.config.BasicStructureConfiguration;
import com.prefab.structures.config.HouseAdvancedConfiguration;
import com.prefab.structures.config.HouseConfiguration;
import com.prefab.structures.config.HouseImprovedConfiguration;
import com.prefab.structures.config.enums.BaseOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Config(name="Prefab")
public class ModConfiguration
implements ConfigData {
    @Comment(value="Item provided to new players when joining a world")
    public StartingItemOptions startingItem = StartingItemOptions.StartingHouse;
    @Comment(value="Can new players for a world receive a starting item?")
    public boolean newPlayersGetStartingItem = true;
    @Comment(value="Add spawners to monster masher")
    public boolean includeSpawnersInMasher = true;
    @Comment(value="Enables preview buttons in screens")
    public boolean enableStructurePreview = true;
    @Comment(value="Bulldozer makes drops")
    public boolean allowBulldozerToCreateDrops = true;
    @Comment(value="Allow water in the End or Custom Dimensions")
    public boolean allowWaterInNonOverworldDimensions = true;
    @Comment(value="Generated mineshafts have chests with materials")
    public boolean includeMineshaftChest = true;
    @Comment(value="Play building sound when generating blueprint")
    public boolean playBuildingSound = true;
    @ConfigEntry.Category(value="recipes")
    public HashMap<String, Boolean> recipes = new HashMap();
    @ConfigEntry.Category(value="chest_options")
    @ConfigEntry.Gui.TransitiveObject
    public ChestOptions chestOptions = new ChestOptions();
    @ConfigEntry.Category(value="starter_options")
    @ConfigEntry.Gui.TransitiveObject
    public StarterHouseOptions starterHouseOptions = new StarterHouseOptions();
    @ConfigEntry.Category(value="structure_options")
    public HashMap<String, HashMap<String, Boolean>> structureOptions = new HashMap();
    @ConfigEntry.Category(value="strict_mode_options")
    @ConfigEntry.Gui.TransitiveObject
    public StrictModeOptions strictModeOptions = new StrictModeOptions();

    public ModConfiguration() {
        this.initialize();
    }

    public void validatePostLoad() {
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize() {
        HashMap<Object, Object> houseImprovedOptions;
        HashMap<Object, Object> houseOptions;
        for (String string : ConfigKeyNames.Keys) {
            if (this.recipes.containsKey(string)) continue;
            this.recipes.put(string, true);
        }
        for (BasicStructureConfiguration.EnumBasicStructureName enumBasicStructureName : BasicStructureConfiguration.EnumBasicStructureName.values()) {
            if (enumBasicStructureName.getName().equals("custom")) continue;
            String key = enumBasicStructureName.getItemTranslationString();
            ArrayList<BaseOption> options = enumBasicStructureName.getBaseOption().getSpecificOptions();
            if (options.size() <= 1) continue;
            HashMap<Object, Object> structureOptions = this.structureOptions.containsKey(key) ? this.structureOptions.get(key) : new HashMap();
            for (BaseOption option : options) {
                if (structureOptions.containsKey(option.getTranslationString())) continue;
                structureOptions.put(option.getTranslationString(), true);
            }
            if (this.structureOptions.containsKey(key)) continue;
            this.structureOptions.put(key, structureOptions);
        }
        String string = "item.prefab.item_house";
        if (this.structureOptions.containsKey(string)) {
            houseOptions = this.structureOptions.get(string);
        } else {
            houseOptions = new HashMap();
            this.structureOptions.put(string, houseOptions);
        }
        for (HouseConfiguration.HouseStyle houseStyle : HouseConfiguration.HouseStyle.values()) {
            if (houseOptions.containsKey(houseStyle.getTranslationString())) continue;
            houseOptions.put(houseStyle.getTranslationString(), true);
        }
        String string2 = "item.prefab.item_house_improved";
        if (this.structureOptions.containsKey(string2)) {
            houseImprovedOptions = this.structureOptions.get(string2);
        } else {
            houseImprovedOptions = new HashMap();
            this.structureOptions.put(string2, houseImprovedOptions);
        }
        for (HouseImprovedConfiguration.HouseStyle houseStyle : HouseImprovedConfiguration.HouseStyle.values()) {
            if (houseImprovedOptions.containsKey(houseStyle.getTranslationString())) continue;
            houseImprovedOptions.put(houseStyle.getTranslationString(), true);
        }
        String string3 = "item.prefab.item_house_advanced";
        if (this.structureOptions.containsKey(string3)) {
            HashMap<String, Boolean> hashMap = this.structureOptions.get(string3);
        } else {
            HashMap hashMap = new HashMap();
            this.structureOptions.put(string3, hashMap);
        }
        for (HouseAdvancedConfiguration.HouseStyle houseStyle : HouseAdvancedConfiguration.HouseStyle.values()) {
            void var4_17;
            if (var4_17.containsKey(houseStyle.getTranslationString())) continue;
            var4_17.put(houseStyle.getTranslationString(), true);
        }
    }

    public CompoundTag writeCompoundTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString(ConfigKeyNames.startingItemName, this.startingItem.toString());
        tag.putBoolean(ConfigKeyNames.newPlayersGetStartingItemName, this.newPlayersGetStartingItem);
        tag.putBoolean(ConfigKeyNames.includeSpawnersInMasherName, this.includeSpawnersInMasher);
        tag.putBoolean(ConfigKeyNames.enableStructurePreviewName, this.enableStructurePreview);
        tag.putBoolean(ConfigKeyNames.includeMineshaftChestName, this.includeMineshaftChest);
        tag.putBoolean(ConfigKeyNames.allowBulldozerToCreateDropsName, this.allowBulldozerToCreateDrops);
        tag.putBoolean(ConfigKeyNames.allowWaterInNonOverworldDimensionsName, this.allowWaterInNonOverworldDimensions);
        tag.putBoolean(ConfigKeyNames.playBuildingSoundName, this.playBuildingSound);
        tag.putBoolean(ConfigKeyNames.addSwordName, this.chestOptions.addSword);
        tag.putBoolean(ConfigKeyNames.addAxeName, this.chestOptions.addAxe);
        tag.putBoolean(ConfigKeyNames.addShovelName, this.chestOptions.addShovel);
        tag.putBoolean(ConfigKeyNames.addHoeName, this.chestOptions.addHoe);
        tag.putBoolean(ConfigKeyNames.addPickAxeName, this.chestOptions.addPickAxe);
        tag.putBoolean(ConfigKeyNames.addArmorName, this.chestOptions.addArmor);
        tag.putBoolean(ConfigKeyNames.addFoodName, this.chestOptions.addFood);
        tag.putBoolean(ConfigKeyNames.addCropsName, this.chestOptions.addCrops);
        tag.putBoolean(ConfigKeyNames.addDirtName, this.chestOptions.addDirt);
        tag.putBoolean(ConfigKeyNames.addCobbleName, this.chestOptions.addCobble);
        tag.putBoolean(ConfigKeyNames.addSaplingsName, this.chestOptions.addSaplings);
        tag.putBoolean(ConfigKeyNames.addTorchesName, this.chestOptions.addTorches);
        tag.putBoolean(ConfigKeyNames.addBedName, this.starterHouseOptions.addBed);
        tag.putBoolean(ConfigKeyNames.addCraftingTableName, this.starterHouseOptions.addCraftingTable);
        tag.putBoolean(ConfigKeyNames.addFurnaceName, this.starterHouseOptions.addFurnace);
        tag.putBoolean(ConfigKeyNames.addChestsName, this.starterHouseOptions.addChests);
        tag.putBoolean(ConfigKeyNames.addChestContentsName, this.starterHouseOptions.addChestContents);
        tag.putBoolean(ConfigKeyNames.addMineshaftName, this.starterHouseOptions.addMineshaft);
        for (Map.Entry<String, Boolean> entry : this.recipes.entrySet()) {
            tag.putBoolean(entry.getKey(), entry.getValue().booleanValue());
        }
        CompoundTag structureOptionTag = this.getStructureOptionCompoundTag();
        tag.put(ConfigKeyNames.structureOptionsName, (Tag)structureOptionTag);
        tag.putBoolean(ConfigKeyNames.strictBuildingModeEnabledName, this.strictModeOptions.enabled);
        tag.putBoolean(ConfigKeyNames.strictBuildingOperatorsBypassRestrictions, this.strictModeOptions.operatorsBypassRestrictions);
        CompoundTag overwritableBlocksTag = this.getOverwritableBlocksTag();
        tag.put(ConfigKeyNames.overwritableBlocksName, (Tag)overwritableBlocksTag);
        CompoundTag overwritableTagsTag = this.getOverwritableTagsTag();
        tag.put(ConfigKeyNames.overwritableTagsName, (Tag)overwritableTagsTag);
        return tag;
    }

    @NotNull
    private CompoundTag getStructureOptionCompoundTag() {
        CompoundTag structureOptionTag = new CompoundTag();
        for (Map.Entry<String, HashMap<String, Boolean>> entry : this.structureOptions.entrySet()) {
            CompoundTag mainItem = new CompoundTag();
            for (Map.Entry<String, Boolean> subEntry : entry.getValue().entrySet()) {
                mainItem.putBoolean(subEntry.getKey(), subEntry.getValue().booleanValue());
            }
            structureOptionTag.put(entry.getKey(), (Tag)mainItem);
        }
        return structureOptionTag;
    }

    @NotNull
    private CompoundTag getOverwritableBlocksTag() {
        return this.convertStringCollection(this.strictModeOptions.overwritableBlocks);
    }

    @NotNull
    private CompoundTag getOverwritableTagsTag() {
        return this.convertStringCollection(this.strictModeOptions.overwritableTags);
    }

    @NotNull
    private CompoundTag convertStringCollection(ArrayList<String> collection) {
        CompoundTag tag = new CompoundTag();
        if (collection != null && !collection.isEmpty()) {
            for (String value : collection) {
                if (StringUtils.isBlank((CharSequence)value) || tag.contains(value)) continue;
                tag.putString(value, value);
            }
        }
        return tag;
    }

    public void readFromTag(CompoundTag tag) {
        this.startingItem = StartingItemOptions.getByName(tag.getString(ConfigKeyNames.startingItemName));
        this.newPlayersGetStartingItem = tag.getBoolean(ConfigKeyNames.newPlayersGetStartingItemName);
        this.includeSpawnersInMasher = tag.getBoolean(ConfigKeyNames.includeSpawnersInMasherName);
        this.enableStructurePreview = tag.getBoolean(ConfigKeyNames.enableStructurePreviewName);
        this.includeMineshaftChest = tag.getBoolean(ConfigKeyNames.includeMineshaftChestName);
        this.allowBulldozerToCreateDrops = tag.getBoolean(ConfigKeyNames.allowBulldozerToCreateDropsName);
        this.allowWaterInNonOverworldDimensions = tag.getBoolean(ConfigKeyNames.allowWaterInNonOverworldDimensionsName);
        this.playBuildingSound = tag.getBoolean(ConfigKeyNames.playBuildingSoundName);
        this.chestOptions.addSword = tag.getBoolean(ConfigKeyNames.addSwordName);
        this.chestOptions.addAxe = tag.getBoolean(ConfigKeyNames.addAxeName);
        this.chestOptions.addShovel = tag.getBoolean(ConfigKeyNames.addShovelName);
        this.chestOptions.addHoe = tag.getBoolean(ConfigKeyNames.addHoeName);
        this.chestOptions.addPickAxe = tag.getBoolean(ConfigKeyNames.addPickAxeName);
        this.chestOptions.addArmor = tag.getBoolean(ConfigKeyNames.addArmorName);
        this.chestOptions.addFood = tag.getBoolean(ConfigKeyNames.addFoodName);
        this.chestOptions.addCrops = tag.getBoolean(ConfigKeyNames.addCropsName);
        this.chestOptions.addDirt = tag.getBoolean(ConfigKeyNames.addDirtName);
        this.chestOptions.addCobble = tag.getBoolean(ConfigKeyNames.addCobbleName);
        this.chestOptions.addSaplings = tag.getBoolean(ConfigKeyNames.addSaplingsName);
        this.chestOptions.addTorches = tag.getBoolean(ConfigKeyNames.addTorchesName);
        this.starterHouseOptions.addBed = tag.getBoolean(ConfigKeyNames.addBedName);
        this.starterHouseOptions.addCraftingTable = tag.getBoolean(ConfigKeyNames.addCraftingTableName);
        this.starterHouseOptions.addFurnace = tag.getBoolean(ConfigKeyNames.addFurnaceName);
        this.starterHouseOptions.addChests = tag.getBoolean(ConfigKeyNames.addChestsName);
        this.starterHouseOptions.addChestContents = tag.getBoolean(ConfigKeyNames.addChestContentsName);
        this.starterHouseOptions.addMineshaft = tag.getBoolean(ConfigKeyNames.addMineshaftName);
        this.recipes.clear();
        this.structureOptions.clear();
        for (String key : ConfigKeyNames.Keys) {
            this.recipes.put(key, tag.getBoolean(key));
        }
        CompoundTag structureOptionsTag = tag.getCompound(ConfigKeyNames.structureOptionsName);
        if (!structureOptionsTag.isEmpty()) {
            for (String key : structureOptionsTag.getAllKeys()) {
                CompoundTag mainItem = structureOptionsTag.getCompound(key);
                HashMap<String, Boolean> structureOptions = new HashMap<String, Boolean>();
                for (String subKey : mainItem.getAllKeys()) {
                    boolean value = mainItem.getBoolean(subKey);
                    structureOptions.put(subKey, value);
                }
                this.structureOptions.put(key, structureOptions);
            }
        }
        this.strictModeOptions.enabled = tag.getBoolean(ConfigKeyNames.strictBuildingModeEnabledName);
        this.strictModeOptions.operatorsBypassRestrictions = tag.getBoolean(ConfigKeyNames.strictBuildingOperatorsBypassRestrictions);
        CompoundTag overwritableBlocksTag = tag.getCompound(ConfigKeyNames.overwritableBlocksName);
        this.processCompoundTagIntoStringArrayList(overwritableBlocksTag, this.strictModeOptions.overwritableBlocks);
        CompoundTag overwritableBlocksTagsTag = tag.getCompound(ConfigKeyNames.overwritableTagsName);
        this.processCompoundTagIntoStringArrayList(overwritableBlocksTagsTag, this.strictModeOptions.overwritableTags);
    }

    private void processCompoundTagIntoStringArrayList(CompoundTag tag, ArrayList<String> arrayList) {
        for (String key : tag.getAllKeys()) {
            String value = tag.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            arrayList.add(value);
        }
    }

    public static enum StartingItemOptions {
        StartingHouse("Starting House"),
        ModerateHouse("Moderate House"),
        Nothing("Nothing");

        private final String name;

        private StartingItemOptions(String name) {
            this.name = name;
        }

        public static StartingItemOptions getByName(String name) {
            StartingItemOptions returnValue = Nothing;
            for (StartingItemOptions options : StartingItemOptions.values()) {
                if (!options.name.equals(name) && !options.name().equals(name)) continue;
                returnValue = options;
                break;
            }
            return returnValue;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ConfigKeyNames {
        public static String compressedStoneKey = "Compressed Stone";
        public static String compressedGlowStoneKey = "Compressed Glowstone";
        public static String compressedDirtKey = "Compressed Dirt";
        public static String compressedChestKey = "Compressed Chest";
        public static String pileOfBricksKey = "Pile of Bricks";
        public static String warehouseKey = "Warehouse";
        public static String warehouseUpgradeKey = "Upgrade";
        public static String advancedWarehouseKey = "Improved Warehouse";
        public static String bundleOfTimberKey = "Bundle of Timber";
        public static String netherGateKey = "Nether Gate";
        public static String machineryTowerKey = "Machinery Tower";
        public static String defenseBunkerKey = "Defense Bunker";
        public static String mineshaftEntranceKey = "Mineshaft Entrance";
        public static String enderGatewayKey = "Ender Gateway";
        public static String aquaBaseKey = "Aqua Base";
        public static String grassyPlainsKey = "Grassy Plains";
        public static String magicTempleKey = "Magic Temple";
        public static String instantBridgeKey = "Instant Bridge";
        public static String paperLanternKey = "Paper Lantern";
        public static String compressedObsidianKey = "Compressed Obsidian";
        public static String villagerHousesKey = "Villager Houses";
        public static String phasicBlockKey = "Phasic Block";
        public static String smartGlassKey = "Boundary Block";
        public static String greenHouseKey = "Green House";
        public static String startingHouseKey = "House";
        public static String glassStairsKey = "Glass Stairs";
        public static String glassSlabsKey = "Glass Slabs";
        public static String moderateHouseKey = "Improved House";
        public static String watchTowerKey = "Watch Tower";
        public static String bulldozerKey = "Bulldozer";
        public static String jailKey = "Jail";
        public static String saloonKey = "Saloon";
        public static String skiLodgeKey = "Ski Lodge";
        public static String windMillKey = "Windmill";
        public static String townHallKey = "Town Hall";
        public static String heapOfTimberKey = "Heap of Timber";
        public static String tonOfTimberKey = "Ton of Timber";
        public static String workshopKey = "Workshop";
        public static String modernBuildingsKey = "Modern Buildings";
        public static String starterFarmKey = "Farm";
        public static String moderateFarmKey = "Improved Farm";
        public static String advancedFarmKey = "Advanced Farm";
        public static String swiftBladeKey = "Swift Blade";
        public static String sickleKey = "Sickle";
        public static String dirtRecipesKey = "Dirt Recipes";
        public static String bunchOfBeetsKey = "Bunch Of Beets";
        public static String bunchOfCarrotsKey = "Bunch Of Carrots";
        public static String bunchOfPotatoesKey = "Bunch Of Potatoes";
        public static String woodenCrateKey = "WoodenCrate";
        public static String quartzCreteKey = "Quartz-Crete";
        public static String houseAdvancedKey = "Advanced House";
        public static String darkLightLampKey = "Dark Light Lamp";
        public static String lightSwitchKey = "Light Switch";
        public static String[] Keys = new String[]{compressedStoneKey, compressedGlowStoneKey, compressedDirtKey, compressedChestKey, pileOfBricksKey, warehouseKey, warehouseUpgradeKey, advancedWarehouseKey, bundleOfTimberKey, netherGateKey, machineryTowerKey, defenseBunkerKey, mineshaftEntranceKey, enderGatewayKey, magicTempleKey, instantBridgeKey, paperLanternKey, compressedObsidianKey, villagerHousesKey, phasicBlockKey, smartGlassKey, greenHouseKey, startingHouseKey, glassStairsKey, glassSlabsKey, moderateHouseKey, grassyPlainsKey, aquaBaseKey, watchTowerKey, bulldozerKey, jailKey, saloonKey, skiLodgeKey, windMillKey, townHallKey, heapOfTimberKey, tonOfTimberKey, workshopKey, modernBuildingsKey, swiftBladeKey, sickleKey, dirtRecipesKey, bunchOfBeetsKey, bunchOfCarrotsKey, bunchOfPotatoesKey, woodenCrateKey, starterFarmKey, moderateFarmKey, advancedFarmKey, quartzCreteKey, houseAdvancedKey, darkLightLampKey, lightSwitchKey};
        static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
        static String enableStructurePreviewName = "Include Structure Previews";
        static String includeMineshaftChestName = "Include Mineshaft Chest";
        static String enableAutomationOptionsFromModerateFarmName = "Enable Automation Options For Moderate Farm";
        static String allowBulldozerToCreateDropsName = "Bulldozer Creates Drops";
        static String allowWaterInNonOverworldDimensionsName = "Include Water In Overworld Dimension Only";
        static String playBuildingSoundName = "Play Building Sound";
        static String addSwordName = "Add Sword";
        static String addAxeName = "Add Axe";
        static String addHoeName = "Add Hoe";
        static String addShovelName = "Add Shovel";
        static String addPickAxeName = "Add Pickaxe";
        static String addArmorName = "Add Armor";
        static String addFoodName = "Add Food";
        static String addCropsName = "Add Crops";
        static String addDirtName = "Add Dirt";
        static String addCobbleName = "Add Cobblestone";
        static String addSaplingsName = "Add Saplings";
        static String addTorchesName = "Add Torches";
        static String startingItemName = "Starting Item";
        static String newPlayersGetStartingItemName = "New Players Get Starting Item";
        static String addBedName = "Add Bed";
        static String addCraftingTableName = "Add Crafting Table";
        static String addFurnaceName = "Add Furnace";
        static String addChestsName = "Add Chests";
        static String addChestContentsName = "Add Chest Contents";
        static String addMineshaftName = "Add Mineshaft";
        static String structureOptionsName = "Structure Options";
        static String strictBuildingModeEnabledName = "Strict Building Mode Enabled";
        static String strictBuildingOperatorsBypassRestrictions = "Strict Building Operators Bypass Restrictions";
        static String overwritableBlocksName = "Overwritable Blocks";
        static String overwritableTagsName = "Overwritable Tags";
    }
}

