/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.config;

import com.prefab.structures.config.StructureConfiguration;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class EntityPlayerConfiguration {
    public static final String Prefab_Player_Key = "Prefab_Data";
    public static final String PLAYER_ENTITY_TAG = "IsPlayerNew";
    public static final String GIVEN_HOUSEBUILDER_TAG = "givenHousebuilder";
    public static final String Built_Starter_house_Tag = "builtStarterHouse";
    public static HashMap<UUID, EntityPlayerConfiguration> playerTagData = new HashMap();
    public boolean givenHouseBuilder = false;
    public boolean builtStarterHouse = false;
    private HashMap<String, StructureConfiguration> clientConfigurations = new HashMap();

    public static EntityPlayerConfiguration loadFromEntity(Player playerEntity) {
        if (playerTagData.containsKey(playerEntity.getUUID())) {
            return playerTagData.get(playerEntity.getUUID());
        }
        EntityPlayerConfiguration returnValue = new EntityPlayerConfiguration();
        playerTagData.put(playerEntity.getUUID(), returnValue);
        return returnValue;
    }

    public static EntityPlayerConfiguration loadFromTag(UUID playerUUID, CompoundTag tag) {
        EntityPlayerConfiguration returnValue = new EntityPlayerConfiguration();
        returnValue.loadFromNBTTagCompound(tag);
        if (playerTagData.containsKey(playerUUID)) {
            playerTagData.replace(playerUUID, returnValue);
        } else {
            playerTagData.put(playerUUID, returnValue);
        }
        return returnValue;
    }

    public void loadFromNBTTagCompound(CompoundTag tag) {
        this.givenHouseBuilder = tag.getBoolean(GIVEN_HOUSEBUILDER_TAG);
        this.builtStarterHouse = tag.getBoolean(Built_Starter_house_Tag);
    }

    public CompoundTag createPlayerTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putBoolean(Built_Starter_house_Tag, this.builtStarterHouse);
        compoundTag.putBoolean(GIVEN_HOUSEBUILDER_TAG, this.givenHouseBuilder);
        return compoundTag;
    }

    public <T extends StructureConfiguration> T getClientConfig(String guiName, Class<T> structureConfiguration) {
        StructureConfiguration config = this.clientConfigurations.get(guiName);
        if (config == null) {
            try {
                config = (StructureConfiguration)structureConfiguration.newInstance();
                this.clientConfigurations.put(guiName, config);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)config;
    }

    public void clearNonPersistedObjects() {
        this.clientConfigurations.clear();
    }
}

