/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.blocks;

import com.prefab.PrefabBase;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPhasic
extends Block {
    protected static final EnumProperty<EnumPhasingProgress> Phasing_Progress = EnumProperty.create((String)"phasic_progress", EnumPhasingProgress.class);
    protected static final BooleanProperty Phasing_Out = BooleanProperty.create((String)"phasing_out");
    protected int tickRate = 2;

    public BlockPhasic() {
        super(PrefabBase.SeeThroughImmovable.get().sound(SoundType.STONE).strength(0.6f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)Phasing_Out, (Comparable)Boolean.valueOf(false))).setValue(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Phasing_Out, Phasing_Progress});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        EnumPhasingProgress progress;
        if (!world.isClientSide() && (progress = (EnumPhasingProgress)((Object)state.getValue(Phasing_Progress))) == EnumPhasingProgress.base) {
            world.scheduleTick(pos, (Block)this, this.tickRate);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.getValue(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.getValue(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? Shapes.block() : Shapes.empty();
    }

    @Nullable
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.getValue(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, worldIn, pos, context);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.getValue(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Shapes.empty();
        }
        VoxelShape aabb = super.getInteractionShape(state, worldIn, pos);
        return aabb;
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.getValue(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return 1.0f;
        }
        return 0.2f;
    }

    protected int findNeighborPhasicBlocks(Level worldIn, BlockPos pos, BlockState desiredBlockState, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return cascadeCount;
        }
        if (setCurrentBlock) {
            cascadedBlockPos.add(pos);
        }
        for (Direction facing : Direction.values()) {
            Block neighborBlock = worldIn.getBlockState(pos.relative(facing)).getBlock();
            if (!(neighborBlock instanceof BlockPhasic)) continue;
            BlockState blockState = worldIn.getBlockState(pos.relative(facing));
            EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.getValue(Phasing_Progress));
            if (cascadedBlockPos.contains(pos.relative(facing)) || progress == desiredBlockState.getValue(Phasing_Progress)) continue;
            setCurrentBlock = true;
            cascadeCount = this.findNeighborPhasicBlocks(worldIn, pos.relative(facing), desiredBlockState, cascadeCount, cascadedBlockPos, setCurrentBlock);
            if (cascadeCount > 100) break;
        }
        return cascadeCount;
    }

    public static enum EnumPhasingProgress implements StringRepresentable
    {
        base(0, "base"),
        twenty_percent(2, "twenty_percent"),
        forty_percent(4, "forty_percent"),
        sixty_percent(6, "sixty_percent"),
        eighty_percent(8, "eighty_percent"),
        transparent(10, "transparent");

        private int meta;
        private String name;

        private EnumPhasingProgress(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPhasingProgress ValueOf(int meta) {
            for (EnumPhasingProgress progress : EnumPhasingProgress.values()) {
                if (progress.meta != meta) continue;
                return progress;
            }
            return base;
        }

        public int getMeta() {
            return this.meta;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

