/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.blocks;

import com.mojang.serialization.MapCodec;
import com.prefab.ModRegistryBase;
import com.prefab.base.TileBlockBase;
import com.prefab.blocks.entities.LightSwitchBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLightSwitch
extends TileBlockBase<LightSwitchBlockEntity> {
    protected static final VoxelShape NORTH_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape UP_AABB;
    protected static final VoxelShape DOWN_AABB;
    public static final DirectionProperty FACING;
    public static final EnumProperty<AttachFace> FACE;
    public static final BooleanProperty POWERED;
    public static final MapCodec<BlockLightSwitch> CODEC;

    public static boolean canAttach(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.relative(direction);
        return levelReader.getBlockState(blockPos2).isFaceSturdy((BlockGetter)levelReader, blockPos2, direction.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState blockState) {
        switch ((AttachFace)blockState.getValue(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)blockState.getValue((Property)FACING);
    }

    public BlockLightSwitch() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).pushReaction(PushReaction.DESTROY).noOcclusion().strength(1.5f, 10.0f).noCollission().strength(0.5f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockLightSwitch(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.onRemove(blockState, level, blockPos, blockState2, bl);
        if (!level.isClientSide && blockState.getBlock() != blockState2.getBlock()) {
            ModRegistryBase.serverModRegistries.getLightSwitchRegistry().remove(level, blockPos);
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            BlockState updatedBlockState = this.cycleSwitch(blockState, level, blockPos);
            float f = (Boolean)updatedBlockState.getValue((Property)POWERED) != false ? 0.6f : 0.5f;
            SoundEvent soundEvent = (Boolean)updatedBlockState.getValue((Property)POWERED) != false ? SoundEvents.STONE_BUTTON_CLICK_ON : SoundEvents.STONE_BUTTON_CLICK_OFF;
            level.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 0.3f, f);
            level.gameEvent((Entity)player, (Holder)((Boolean)updatedBlockState.getValue((Property)POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), blockPos);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState cycleSwitch(BlockState blockState, Level level, BlockPos blockPos) {
        blockState = (BlockState)blockState.cycle((Property)POWERED);
        level.setBlock(blockPos, blockState, 3);
        ModRegistryBase.serverModRegistries.getLightSwitchRegistry().flipSwitch(level, blockPos, (Boolean)blockState.getValue((Property)POWERED));
        return blockState;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((AttachFace)blockState.getValue(FACE)) {
            case FLOOR: {
                return UP_AABB;
            }
            case WALL: {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        return DOWN_AABB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] directions;
        for (Direction direction : directions = ctx.getNearestLookingDirections()) {
            BlockState blockState = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockState.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) continue;
            return blockState;
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (!level.isClientSide) {
            ModRegistryBase.serverModRegistries.getLightSwitchRegistry().register(level, blockPos);
        }
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return BlockLightSwitch.canAttach(levelReader, blockPos, BlockLightSwitch.getConnectedDirection(blockState).getOpposite());
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return BlockLightSwitch.getConnectedDirection(blockState).getOpposite() == direction && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{FACE}).add(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new LightSwitchBlockEntity(blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    static {
        CODEC = BlockLightSwitch.simpleCodec(BlockLightSwitch::new);
        FACING = HorizontalDirectionalBlock.FACING;
        FACE = EnumProperty.create((String)"face", AttachFace.class);
        POWERED = BooleanProperty.create((String)"powered");
        NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        WEST_AABB = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        DOWN_AABB = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

