/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.blocks;

import com.prefab.ModRegistryBase;
import com.prefab.blocks.IGrassSpreadable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;

public class BlockCustomWall
extends WallBlock
implements IGrassSpreadable {
    public EnumType BlockVariant;

    public BlockCustomWall(Block modelBlock, EnumType variant) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)variant.getBlockBehaviour()).strength(modelBlock.defaultDestroyTime(), modelBlock.getExplosionResistance() * 5.0f / 3.0f).sound(modelBlock.defaultBlockState().getSoundType()));
        this.BlockVariant = variant;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.BlockVariant == EnumType.DIRT;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.DetermineGrassSpread(state, worldIn, pos, random);
    }

    @Override
    public BlockState getGrassBlockState(BlockState originalState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)ModRegistryBase.GrassWall.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)((WallSide)originalState.getValue((Property)WallBlock.EAST_WALL)))).setValue((Property)WallBlock.WEST_WALL, (Comparable)((WallSide)originalState.getValue((Property)WallBlock.WEST_WALL)))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)((WallSide)originalState.getValue((Property)WallBlock.NORTH_WALL)))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)((WallSide)originalState.getValue((Property)WallBlock.SOUTH_WALL)))).setValue((Property)WallBlock.WATERLOGGED, (Comparable)((Boolean)originalState.getValue((Property)WallBlock.WATERLOGGED)))).setValue((Property)WallBlock.UP, (Comparable)((Boolean)originalState.getValue((Property)WallBlock.UP)));
    }

    public static enum EnumType implements StringRepresentable
    {
        DIRT(0, "block_dirt_wall", "block_dirt_wall", (BlockBehaviour)Blocks.DIRT),
        GRASS(1, "block_grass_wall", "block_grass_wall", (BlockBehaviour)Blocks.DIRT);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private String unlocalizedName;
        private BlockBehaviour blockBehaviour;

        private EnumType(int meta, String name, String unlocalizedName, BlockBehaviour blockBehaviour) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.blockBehaviour = blockBehaviour;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public BlockBehaviour getBlockBehaviour() {
            return this.blockBehaviour;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType customwall$enumtype;
                EnumType.META_LOOKUP[customwall$enumtype.getMetadata()] = customwall$enumtype = enumTypeArray[i];
            }
        }
    }
}

