/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.blocks;

import com.prefab.PrefabBase;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBoundary
extends Block {
    public static final BooleanProperty Powered = BooleanProperty.create((String)"powered");

    public BlockBoundary() {
        super(PrefabBase.SeeThroughImmovable.get().sound(SoundType.STONE).strength(0.6f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)Powered, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Powered});
    }

    public RenderShape getRenderShape(BlockState state) {
        boolean powered = (Boolean)state.getValue((Property)Powered);
        return powered ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean powered = (Boolean)state.getValue((Property)Powered);
        return powered ? Shapes.block() : Shapes.empty();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(world, pos, state, player);
        boolean poweredSide = world.hasNeighborSignal(pos);
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(world, pos, false, 0, new ArrayList<BlockPos>(), false);
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean poweredSide = context.getLevel().hasNeighborSignal(context.getClickedPos());
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(context.getLevel(), context.getClickedPos(), true, 0, new ArrayList<BlockPos>(), false);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)Powered, (Comparable)Boolean.valueOf(poweredSide));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.isClientSide && blockIn.defaultBlockState().isSignalSource()) {
            boolean poweredSide = worldIn.hasNeighborSignal(pos);
            this.setNeighborGlassBlocksPoweredStatus(worldIn, pos, poweredSide, 0, new ArrayList<BlockPos>(), true);
        }
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        boolean powered = (Boolean)state.getValue((Property)Powered);
        if (powered && state.isSolidRender(worldIn, pos)) {
            return worldIn.getMaxLightLevel();
        }
        return state.propagatesSkylightDown(worldIn, pos) ? 0 : 1;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        boolean powered = (Boolean)state.getValue((Property)Powered);
        return !powered || !Block.isShapeFullBlock((VoxelShape)state.getShape(reader, pos)) && state.getFluidState().isEmpty();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    @Deprecated
    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (!((Boolean)state.getValue((Property)Powered)).booleanValue()) {
            return Shapes.empty();
        }
        return Shapes.block();
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        if (!((Boolean)blockState.getValue((Property)Powered)).booleanValue()) {
            return 1.0f;
        }
        return 0.2f;
    }

    protected void setNeighborGlassBlocksPoweredStatus(Level world, BlockPos pos, boolean isPowered, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return;
        }
        if (setCurrentBlock) {
            BlockState state = world.getBlockState(pos);
            world.setBlock(pos, (BlockState)state.setValue((Property)Powered, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
        cascadedBlockPos.add(pos);
        for (Direction facing : Direction.values()) {
            Block neighborBlock = world.getBlockState(pos.relative(facing)).getBlock();
            if (!(neighborBlock instanceof BlockBoundary) || cascadedBlockPos.contains(pos.relative(facing))) continue;
            ((BlockBoundary)neighborBlock).setNeighborGlassBlocksPoweredStatus(world, pos.relative(facing), isPowered, cascadeCount, cascadedBlockPos, true);
        }
    }
}

