/*
 * Decompiled with CFR 0.152.
 */
package com.prefab.base;

import com.prefab.PrefabBase;
import com.prefab.base.BaseConfig;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityBase<T extends BaseConfig>
extends BlockEntity {
    protected T config;

    protected TileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T value) {
        this.config = value;
        this.setChanged();
    }

    public Class<T> getTypeParameterClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.worldPosition.getX() == 0 && this.worldPosition.getY() == 0 && this.worldPosition.getZ() == 0) {
            return null;
        }
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean triggerEvent(int id, int type) {
        return true;
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.config = ((BaseConfig)this.createConfigInstance()).ReadFromCompoundNBT(compound);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.config != null) {
            ((BaseConfig)this.config).WriteToNBTCompound(compound);
        }
    }

    public T createConfigInstance() {
        try {
            return (T)((BaseConfig)this.getTypeParameterClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            PrefabBase.logger.log(Level.ERROR, e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

