/*
 * Decompiled with CFR 0.152.
 */
package com.prefab;

import com.prefab.PrefabBase;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static String[] WrapString(String value) {
        return Utils.WrapString(value, 50);
    }

    public static String[] WrapString(String value, int width) {
        String result = WordUtils.wrap((String)value, (int)width);
        String[] results = result.split("\n");
        String[] returnValue = new String[results.length];
        for (int i = 0; i < results.length; ++i) {
            returnValue[i] = results[i].trim();
        }
        return returnValue;
    }

    public static ArrayList<Component> WrapStringToLiterals(String value) {
        return Utils.WrapStringToLiterals(value, 50);
    }

    public static MutableComponent createTextComponent(String value) {
        return Component.literal((String)value);
    }

    public static ArrayList<Component> WrapStringToLiterals(String value, int width) {
        String[] values = Utils.WrapString(value, width);
        ArrayList<Component> returnValue = new ArrayList<Component>();
        for (String stringValue : values) {
            returnValue.add((Component)Utils.createTextComponent(stringValue));
        }
        return returnValue;
    }

    public static Direction getDirectionByName(String name) {
        if (!StringUtils.isBlank((CharSequence)name)) {
            for (Direction direction : Direction.values()) {
                if (!direction.toString().equalsIgnoreCase(name)) continue;
                return direction;
            }
        }
        return Direction.NORTH;
    }

    @NotNull
    public static ArrayList<Block> getBlocksWithTagKey(TagKey<Block> tagKey) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Holder blockHolder : BuiltInRegistries.BLOCK.getTagOrEmpty(tagKey)) {
            blocks.add((Block)blockHolder.value());
        }
        return blocks;
    }

    public static boolean doesBlockStateHaveTag(BlockState blockState, ResourceLocation location) {
        for (TagKey tagKey : blockState.getTags().toList()) {
            if (!tagKey.location().toString().equalsIgnoreCase(location.toString())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> getItemStacksWithTag(ResourceLocation resourceLocation) {
        TagKey tags = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(tags)) {
            itemStacks.add(new ItemStack((ItemLike)holder.value()));
        }
        return itemStacks;
    }

    public static BlockState readBlockState(CompoundTag tag) {
        if (!tag.contains("Name", 8)) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("Name")));
        BlockState blockState = block.defaultBlockState();
        if (tag.contains("Properties", 10)) {
            CompoundTag compoundTag = tag.getCompound("Properties");
            StateDefinition stateDefinition = block.getStateDefinition();
            for (String s : compoundTag.getAllKeys()) {
                Property property = stateDefinition.getProperty(s);
                if (property == null) continue;
                blockState = Utils.setValueHelper(blockState, property, s, compoundTag, tag);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S blockState, Property<T> property, String tagKey, CompoundTag compoundTag, CompoundTag originalTag) {
        Optional optional = property.getValue(compoundTag.getString(tagKey));
        if (optional.isPresent()) {
            return (S)((StateHolder)blockState.setValue(property, (Comparable)optional.get()));
        }
        PrefabBase.logger.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)tagKey, (Object)compoundTag.getString(tagKey), (Object)originalTag.toString());
        return blockState;
    }
}

