/*
 * Decompiled with CFR 0.152.
 */
package com.prefab;

import com.prefab.ModRegistryBase;
import com.prefab.base.BaseConfig;
import com.prefab.blocks.BlockCustomWall;
import com.prefab.blocks.BlockGrassSlab;
import com.prefab.blocks.BlockGrassStairs;
import com.prefab.config.EntityPlayerConfiguration;
import com.prefab.config.StructureScannerConfig;
import com.prefab.gui.screens.GuiStructureScanner;
import com.prefab.structures.gui.GuiStructure;
import com.prefab.structures.items.StructureItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ClientModRegistryBase {
    public static ArrayList<StructureScannerConfig> structureScanners;
    public static EntityPlayerConfiguration playerConfig;
    public static HashMap<StructureItem, GuiStructure> ModGuis;

    public static void registerModComponents() {
        ClientModRegistryBase.RegisterGuis();
    }

    public static void openGuiForItem(UseOnContext itemUseContext) {
        for (Map.Entry<StructureItem, GuiStructure> entry : ModGuis.entrySet()) {
            if (entry.getKey() != itemUseContext.getItemInHand().getItem()) continue;
            GuiStructure screen = entry.getValue();
            screen.pos = itemUseContext.getClickedPos();
            Minecraft.getInstance().setScreen((Screen)screen);
        }
    }

    public static void openGuiForBlock(BlockPos blockPos, Level world, BaseConfig config) {
        GuiStructureScanner screen = null;
        if (config instanceof StructureScannerConfig) {
            screen = new GuiStructureScanner(blockPos, world, (StructureScannerConfig)config);
        }
        if (screen != null) {
            Minecraft.getInstance().setScreen(screen);
        }
    }

    public static void RegisterBlockRenderer() {
        Minecraft.getInstance().getBlockColors().register((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)worldIn, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{ModRegistryBase.GrassWall, ModRegistryBase.GrassSlab, ModRegistryBase.GrassStairs});
        Minecraft.getInstance().itemColors.register((stack, tintIndex) -> {
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem itemBlock = (BlockItem)item;
                boolean paintBlock = false;
                if (itemBlock.getBlock() instanceof BlockCustomWall) {
                    BlockCustomWall customWall = (BlockCustomWall)itemBlock.getBlock();
                    if (customWall.BlockVariant == BlockCustomWall.EnumType.GRASS) {
                        paintBlock = true;
                    }
                } else if (itemBlock.getBlock() instanceof BlockGrassSlab) {
                    paintBlock = true;
                } else if (itemBlock.getBlock() instanceof BlockGrassStairs) {
                    paintBlock = true;
                }
                if (paintBlock) {
                    BlockPos pos = Minecraft.getInstance().player.blockPosition();
                    ClientLevel world = Minecraft.getInstance().level;
                    return BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos);
                }
            }
            return -1;
        }, (ItemLike[])new Block[]{ModRegistryBase.GrassWall, ModRegistryBase.GrassSlab, ModRegistryBase.GrassStairs});
    }

    public static void RegisterGuis() {
        for (Consumer<Object> consumer : ModRegistryBase.guiRegistrations) {
            consumer.accept(null);
        }
    }

    static {
        playerConfig = new EntityPlayerConfiguration();
        ModGuis = new HashMap();
        structureScanners = new ArrayList();
    }
}

