/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.mixinInterfaces.GolemOrderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class MixinServerPlayerMode {
    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void strawgolem_onShiftRightClickContainer(ServerPlayer pPlayer, Level pLevel, ItemStack pStack, InteractionHand pHand, BlockHitResult pHitResult, CallbackInfoReturnable<InteractionResult> cir) {
        ServerPlayer serverPlayer;
        if (!pPlayer.isShiftKeyDown() || !pPlayer.getMainHandItem().isEmpty()) {
            return;
        }
        BlockPos blockPos = pHitResult.getBlockPos();
        BlockEntity blockEntity = pLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof Container && (serverPlayer = pPlayer) instanceof GolemOrderer) {
            GolemOrderer orderer = (GolemOrderer)serverPlayer;
            StrawGolem golem = orderer.strawgolemRewrite$getGolem();
            if (golem != null && golem.isAlive()) {
                golem.setPriorityPos(blockPos);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"strawgolem.ordering.complete"), true);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                cir.cancel();
            } else if (golem != null && !golem.isAlive()) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"strawgolem.ordering.failure"), true);
            }
            orderer.strawgolemRewrite$setGolem(null);
        }
    }
}

