/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.registry.EntityRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class MixinPumpkin {
    @Shadow
    @Final
    private static Predicate<BlockState> PUMPKINS_PREDICATE;
    @Unique
    private BlockPattern strawgolem$strawGolemFull;
    @Unique
    private BlockPattern strawgolem$strawGolemBase;

    @Shadow
    private static void spawnGolemInWorld(Level pLevel, BlockPattern.BlockPatternMatch pPatternMatch, Entity pGolem, BlockPos pPos) {
    }

    @ModifyReturnValue(method={"canSpawnGolem"}, at={@At(value="RETURN")})
    private boolean modifyCanSpawnGolem(boolean original, LevelReader pLevel, BlockPos pPos) {
        if (!original) {
            return this.strawgolem$getOrCreateStrawGolemBase().find(pLevel, pPos) != null;
        }
        return true;
    }

    @Inject(method={"trySpawnGolem"}, at={@At(value="HEAD")})
    private void trySpawnGolem(Level pLevel, BlockPos pPos, CallbackInfo ci) {
        StrawGolem strawGolem;
        BlockPattern.BlockPatternMatch patternMatch = this.strawgolem$getOrCreateStrawGolemFull().find((LevelReader)pLevel, pPos);
        if (patternMatch != null && (strawGolem = (StrawGolem)EntityRegistry.STRAWGOLEM.get().create(pLevel)) != null) {
            MixinPumpkin.spawnGolemInWorld(pLevel, patternMatch, (Entity)strawGolem, patternMatch.getBlock(0, 1, 0).getPos());
        }
    }

    @Unique
    private BlockPattern strawgolem$getOrCreateStrawGolemFull() {
        if (this.strawgolem$strawGolemFull == null) {
            this.strawgolem$strawGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.HAY_BLOCK))).build();
        }
        return this.strawgolem$strawGolemFull;
    }

    @Unique
    private BlockPattern strawgolem$getOrCreateStrawGolemBase() {
        if (this.strawgolem$strawGolemBase == null) {
            this.strawgolem$strawGolemBase = BlockPatternBuilder.start().aisle(new String[]{" ", "#"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.HAY_BLOCK))).build();
        }
        return this.strawgolem$strawGolemBase;
    }
}

