/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;

public class GolemWanderGoal
extends WaterAvoidingRandomStrollGoal {
    private int wanderLimit = Constants.Golem.wanderRange;
    private BlockPos startPos;

    public GolemWanderGoal(StrawGolem golem) {
        super((PathfinderMob)golem, StrawGolem.defaultWalkSpeed);
    }

    public void start() {
        super.start();
        this.startPos = this.mob.blockPosition();
    }

    public boolean canUse() {
        return this.mob.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.startPos.distManhattan((Vec3i)this.mob.blockPosition()) < this.wanderLimit;
    }
}

