/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.hero.strawgolem.golem.StrawGolem;

public abstract class GolemMoveToBlockGoal
extends MoveToBlockGoal {
    public GolemMoveToBlockGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
        super(pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
    }

    protected boolean golemCollision(StrawGolem golem) {
        return !golem.level().getEntitiesOfClass(StrawGolem.class, golem.getBoundingBox().inflate(0.3), gol -> !gol.position().equals((Object)golem.position())).isEmpty();
    }

    protected void nudge(StrawGolem golem) {
        Vec3 nudgeDir = Vec3.ZERO;
        Direction dir = golem.getDirection();
        if (dir == Direction.NORTH) {
            nudgeDir = Vec3.atLowerCornerOf((Vec3i)Direction.WEST.getNormal());
        } else if (dir == Direction.SOUTH) {
            nudgeDir = Vec3.atLowerCornerOf((Vec3i)Direction.EAST.getNormal());
        } else if (dir == Direction.WEST) {
            nudgeDir = Vec3.atLowerCornerOf((Vec3i)Direction.NORTH.getNormal());
        } else if (dir == Direction.EAST) {
            nudgeDir = Vec3.atLowerCornerOf((Vec3i)Direction.SOUTH.getNormal());
        }
        double multiplier = 0.05;
        golem.push(nudgeDir.multiply(multiplier, multiplier, multiplier));
    }

    protected void nudgeTowards(StrawGolem golem, Entity e) {
        Vec3 nudgeDir = Vec3.ZERO;
        nudgeDir.add(golem.getX() - e.getX(), 0.0, golem.getZ() - e.getZ());
        double multiplier = 0.05;
        golem.push(nudgeDir.multiply(multiplier, multiplier, multiplier));
    }

    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return false;
    }
}

