/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.BiPredicate;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemMoveToBlockGoal;
import org.hero.strawgolem.mixinInterfaces.StemFruit;

public class GolemGrabGoal
extends GolemMoveToBlockGoal {
    List<ItemEntity> items;
    static Set<Item> validItems;
    ItemEntity currentTarget;
    StrawGolem golem;
    int pickupTicks = 0;
    boolean pickUp = false;
    boolean itemAcquired = false;
    boolean stop = false;
    BiPredicate<ItemEntity> predicate = (gol, entity) -> this.isInValidItems(entity.getItem().getItem()) && !entity.hasPickUpDelay() && ReachHelper.canPath((Mob)this.golem, entity.blockPosition());

    public GolemGrabGoal(StrawGolem pMob) {
        super((PathfinderMob)pMob, Constants.Golem.defaultWalkSpeed, Constants.Golem.searchRange, 3);
        this.golem = pMob;
        this.constructValidItems();
    }

    private void updateNearbyItems() {
        this.items = this.golem.level().getEntitiesOfClass(ItemEntity.class, this.golem.getBoundingBox().inflate((double)Constants.Golem.searchRange, 3.0, (double)Constants.Golem.searchRange)).stream().filter(entity -> this.predicate.filter(this.golem, (ItemEntity)entity)).collect(Collectors.toCollection(ArrayList::new));
        this.items.sort((item1, item2) -> item2.getAge() - item1.getAge());
    }

    protected boolean hasNearbyItem() {
        if (this.items == null || this.items.isEmpty()) {
            this.updateNearbyItems();
        }
        return !this.items.isEmpty();
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.stop = true;
        this.itemAcquired = false;
    }

    public void tick() {
        if (!(this.itemAcquired || this.currentTarget != null && this.currentTarget.isAlive())) {
            this.updateNearbyItems();
            if (this.items.isEmpty()) {
                this.stop();
                return;
            }
            this.currentTarget = this.items.getFirst();
            this.blockPos = this.currentTarget.blockPosition();
            this.moveMobToBlock();
        }
        if ((double)this.mob.distanceTo((Entity)this.currentTarget) >= 1.5 && this.golem.getNavigation().isDone()) {
            this.moveMobToBlock();
        }
        if (!this.itemAcquired && !this.pickUp && ReachHelper.canReach((Mob)this.golem, this.currentTarget.blockPosition()) && this.golem.carryStatus() == 0 && this.currentTarget.isAlive() && !this.currentTarget.hasPickUpDelay() && this.golem.onGround()) {
            this.currentTarget.setPickUpDelay(40);
            this.golem.lookAt((Entity)this.currentTarget, 50.0f, 50.0f);
            this.golem.setPickupStatus(this.currentTarget.getItem());
            this.pickUp = true;
        } else if (this.itemAcquired || this.pickUp && this.currentTarget.isAlive() && this.golem.carryStatus() == 0 && ReachHelper.canReach((Mob)this.golem, this.currentTarget.blockPosition())) {
            if (this.pickupTicks == 5) {
                this.golem.stopInPlace();
            }
            if (this.pickupTicks == 20) {
                this.golem.setItemSlot(EquipmentSlot.MAINHAND, this.currentTarget.getItem());
                this.itemAcquired = true;
                this.currentTarget.setItem(ItemStack.EMPTY);
            } else if (this.pickupTicks >= 40) {
                this.pickUp = false;
                this.golem.setPickupStatus(0);
                this.stop();
            }
            ++this.pickupTicks;
        } else if (this.pickupTicks != 0 || this.pickUp) {
            this.itemAcquired = false;
            this.pickUp = false;
            this.golem.setPickupStatus(0);
            this.pickupTicks = 0;
            this.moveMobToBlock();
        }
    }

    public void start() {
        this.updateNearbyItems();
        this.stop = false;
        if (this.items.isEmpty()) {
            return;
        }
        this.currentTarget = this.items.getFirst();
        this.moveMobToBlock();
    }

    protected void moveMobToBlock() {
        if (this.currentTarget != null) {
            this.mob.getNavigation().moveTo(this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getZ(), 0, this.speedModifier);
        }
    }

    public boolean canContinueToUse() {
        return !this.stop && (this.golem.carryStatus() == 0 || this.pickupTicks <= 40) && this.hasNearbyItem();
    }

    public boolean canUse() {
        return this.golem.carryStatus() == 0 && this.hasNearbyItem() && VisionHelper.canSee((Entity)this.golem, this.items.getFirst().blockPosition());
    }

    private boolean isInValidItems(Item item) {
        if (validItems == null || validItems.isEmpty()) {
            return false;
        }
        return validItems.contains(item);
    }

    private void constructValidItems() {
        if (validItems != null) {
            return;
        }
        validItems = new HashSet<Item>();
        ResourceLocation location = ResourceLocation.tryParse((String)"crops");
        if (location == null) {
            return;
        }
        try {
            for (Holder blockHolder : ((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location)).get()).stream().toList()) {
                Object item;
                Object object = blockHolder.value();
                if (object instanceof StemFruit) {
                    StemFruit fruitStem = (StemFruit)object;
                    item = fruitStem.strawgolemRewrite$getFruit().asItem();
                    if (item == Items.AIR) continue;
                    validItems.add(fruitStem.strawgolemRewrite$getFruit().asItem());
                    continue;
                }
                item = blockHolder.value();
                if (item instanceof CropBlock) {
                    CropBlock crop = (CropBlock)item;
                    item = this.golem.level();
                    if (item instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)item;
                        BlockState state = crop.getStateForAge(crop.getMaxAge());
                        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.ORIGIN, (Object)this.mob.position());
                        List drops = state.getDrops(builder).stream().toList();
                        for (ItemStack drop : drops) {
                            validItems.add(drop.getItem());
                        }
                        validItems.add(((Block)blockHolder.value()).asItem());
                        continue;
                    }
                }
                if (((Block)blockHolder.value()).asItem() == Items.AIR) continue;
                validItems.add(((Block)blockHolder.value()).asItem());
            }
        }
        catch (Throwable e) {
            Constants.LOG.error("Error constructing valid items! {}", (Object)e.getMessage());
        }
    }
}

