/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.golem.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.hero.strawgolem.Constants;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.golem.api.ContainerHelper;
import org.hero.strawgolem.golem.api.ReachHelper;
import org.hero.strawgolem.golem.api.VisionHelper;
import org.hero.strawgolem.golem.goals.GolemMoveToBlockGoal;

public class GolemDepositGoal
extends GolemMoveToBlockGoal {
    private StrawGolem golem;
    private boolean done = false;

    public GolemDepositGoal(StrawGolem golem) {
        super((PathfinderMob)golem, Constants.Golem.defaultWalkSpeed, Constants.Golem.searchRange, 3);
        this.golem = golem;
    }

    public void start() {
        this.blockPos = this.golem.deliverer.getDeliverable();
        if (this.blockPos == null) {
            Constants.LOG.error("Deposit Start Error!");
            this.stop();
            this.done = true;
        } else {
            this.moveMobToBlock();
            this.tryTicks = 0;
        }
    }

    public void tick() {
        super.tick();
        if (this.blockPos == null) {
            Constants.LOG.error("Missing block position!");
        } else if (this.mob.hasItemInSlot(EquipmentSlot.MAINHAND) && ReachHelper.canReach((Mob)this.mob, this.blockPos)) {
            this.golem.deliverer.deliver((LevelReader)this.golem.level(), this.blockPos);
            this.tryPlaySound();
            this.golem.getNavigation().stop();
            this.done = true;
        } else if (this.shouldRecalculatePath() && this.golemCollision(this.golem)) {
            this.nudge(this.golem);
        }
    }

    public boolean canUse() {
        return this.mob.hasItemInSlot(EquipmentSlot.MAINHAND) && this.golem.deliverer.getDeliverable() != null;
    }

    public boolean canContinueToUse() {
        return !this.done && ContainerHelper.isContainer((Mob)this.mob, this.blockPos) && this.canUse() && this.golem.getNavigation().getPath() != null;
    }

    protected void moveMobToBlock() {
        try {
            this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 0, this.speedModifier);
        }
        catch (Exception e) {
            this.stop();
            Constants.LOG.error(e.getMessage());
        }
    }

    private SoundEvent tryParseSound() {
        try {
            BlockEntity block = this.golem.level().getBlockEntity(this.blockPos);
            if (block == null) {
                return null;
            }
            ResourceLocation location = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)block.getType());
            if (location == null) {
                return null;
            }
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.tryParse((String)("block." + location.getPath() + ".open")));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void tryPlaySound() {
        SoundEvent event = this.tryParseSound();
        if (event == null) {
            event = SoundEvents.CHEST_OPEN;
        }
        this.golem.level().playSound(null, this.blockPos, event, SoundSource.BLOCKS, 0.5f, this.golem.level().random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockEntity(blockPos) instanceof Container && VisionHelper.canSee((Entity)this.mob, this.mob.getOnPos());
    }
}

