/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SnowParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float rotSpeed = 0.0f;
    private final float rotAccel = 10.0f;
    private final float rotDrag = 0.5f;

    public SnowParticle(ClientLevel level, double x, double y, double z, double xv, double yv, double zv, SpriteSet spriteSet) {
        super(level, x, y, z);
        float tmp;
        this.spriteSet = spriteSet;
        this.gravity = 0.5f;
        this.quadSize = 0.02f;
        this.lifetime = 50;
        this.roll = tmp = (float)((double)(level.getRandom().nextFloat() * 2.0f) * Math.PI);
        this.oRoll = tmp;
        this.friction = 0.9f;
        this.setParticleSpeed(xv / 20.0, yv / 20.0, zv / 20.0);
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        this.setSpriteFromAge(this.spriteSet);
        this.oRoll = this.roll;
        if (!this.onGround) {
            this.rotSpeed += this.rotAccel / 20.0f;
            this.rotSpeed *= 1.0f - this.rotDrag / 20.0f;
            this.roll += this.rotSpeed;
        }
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

