/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.hero.strawgolem.client.GolemModel;
import org.hero.strawgolem.client.particle.SimplerParticleType;
import org.hero.strawgolem.golem.StrawGolem;
import org.hero.strawgolem.registry.ParticleRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.specialty.DynamicGeoEntityRenderer;

public class GolemRenderer
extends DynamicGeoEntityRenderer<StrawGolem> {
    public GolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GolemModel());
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<StrawGolem>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, StrawGolem golem) {
                if (bone.getName().equals("item")) {
                    return golem.getItemBySlot(EquipmentSlot.MAINHAND);
                }
                return null;
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, StrawGolem golem, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == golem.getItemBySlot(EquipmentSlot.MAINHAND)) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)((StrawGolem)GolemRenderer.this.animatable), bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, StrawGolem animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.getGeoModel().getAnimationProcessor().getBone("hat").setHidden(!animatable.hasHat());
        this.getGeoModel().getAnimationProcessor().getBone("dynamicsnow").setHidden(!animatable.isFestive());
        this.getGeoModel().getAnimationProcessor().getBone("snow").setHidden(!animatable.isFestive() || !animatable.hasHat());
        this.getGeoModel().getAnimationProcessor().getBone("barrel").setHidden(!animatable.hasBarrel());
        GeoBone bon = this.getGeoModel().getAnimationProcessor().getBone("locator");
        if (bon != null) {
            bon.getLocalPosition();
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void actuallyRender(PoseStack poseStack, StrawGolem animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.getGeoModel().getAnimationProcessor().getBone("locator");
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderFinal(PoseStack poseStack, StrawGolem animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (animatable.createSnow) {
            animatable.createSnow = false;
            this.spawnParticleAtLocator(animatable, "locator", (SimplerParticleType)ParticleRegistry.snow.get(), (SimplerParticleType)ParticleRegistry.snowfall.get(), poseStack);
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
    }

    public void spawnParticleAtLocator(StrawGolem golem, String locatorName, SimplerParticleType snow, SimplerParticleType snowfall, PoseStack poseStack) {
        if (!golem.level().isClientSide) {
            return;
        }
        GeoBone bon = this.getGeoModel().getAnimationProcessor().getBone(locatorName);
        if (bon == null) {
            return;
        }
        Vec3 pos = golem.position().add(new Vec3(-bon.getModelPosition().x / 16.0, bon.getModelPosition().y / 16.0, bon.getModelPosition().z / 16.0).yRot((float)Math.toRadians(-golem.getYRot() + 180.0f)));
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        double speed = 1.0;
        Vec3 lookAngle = golem.getLookAngle();
        double velX = lookAngle.x * speed;
        double velZ = lookAngle.z * speed;
        if (golem.level().isClientSide) {
            double offsetZ;
            double offsetX;
            int i;
            for (i = 0; i < 3; ++i) {
                offsetX = (golem.level().random.nextDouble() - 0.5) * 0.4;
                offsetZ = (golem.level().random.nextDouble() - 0.5) * 0.4;
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)snowfall, x + offsetX, y, z + offsetZ, velX * 2.0, 0.0, velZ * 2.0);
            }
            for (i = 0; i < 100; ++i) {
                offsetX = (golem.level().random.nextDouble() - 0.5) * 0.4;
                offsetZ = (golem.level().random.nextDouble() - 0.5) * 0.4;
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)snow, x + offsetX, y, z + offsetZ, velX, 0.0, velZ);
            }
        }
    }
}

