/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem.client;

import org.hero.strawgolem.golem.StrawGolem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class GolemArmAnimationController
extends AnimationController<StrawGolem> {
    private static final RawAnimation[] arms = new RawAnimation[]{RawAnimation.begin().thenPlay("arms_idle"), RawAnimation.begin().thenPlay("arms_walk"), RawAnimation.begin().thenPlay("arms_run"), RawAnimation.begin().thenPlay("arms_hold_item"), RawAnimation.begin().thenPlay("arms_hold_block"), RawAnimation.begin().thenPlay("arms_scared")};
    private static final AnimationController.AnimationStateHandler<StrawGolem> PREDICATE = event -> {
        StrawGolem golem = (StrawGolem)event.getAnimatable();
        if (golem.pickupStatus() != 0 || golem.shouldForceAnimationReset()) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (controller.getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            controller.forceAnimationReset();
        }
        if (golem.isScared()) {
            controller.setAnimation(arms[5]);
        } else if (golem.holdItemAbove()) {
            controller.setAnimation(arms[4]);
        } else if (golem.carryStatus() != 0) {
            controller.setAnimation(arms[3]);
        } else {
            controller.setAnimation(arms[golem.movementStatus()]);
        }
        return PlayState.CONTINUE;
    };

    public GolemArmAnimationController(StrawGolem animatable) {
        super((GeoAnimatable)animatable, "arms_handler", 4, PREDICATE);
    }
}

