/*
 * Decompiled with CFR 0.152.
 */
package org.hero.strawgolem;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.hero.strawgolem.config.Config;
import org.hero.strawgolem.platform.services.IPlatformHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final String MODID = "strawgolem";
    public static final String MOD_NAME = "Straw Golem";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Straw Golem");
    public static final IPlatformHelper COMMON_PLATFORM = ServiceLoader.load(IPlatformHelper.class).findFirst().orElseThrow();
    public static final Config CONFIG = new Config();

    public static class Animation {
        public static final int TRANSITION_TIME = 4;
    }

    public static class Golem {
        public static final float maxHealth = CONFIG.getFloat("Max Health");
        public static final int barrelHealth = CONFIG.getInt("Barrel Max Health");
        public static final double defaultMovement = 0.23;
        public static final double defaultWalkSpeed = CONFIG.getDouble("Walk Speed");
        public static final double defaultRunSpeed = CONFIG.getDouble("Run Speed");
        public static final int wanderRange = CONFIG.getInt("Wander Range");
        public static final boolean panic = CONFIG.getBool("Panic When Hurt");
        public static final int searchRange = CONFIG.getInt("Harvest Range");
        public static final int searchRangeVertical = 3;
        public static final double depositDistance = 1.5;
        public static boolean blockHarvest = CONFIG.getBool("Block Harvesting");
        public static boolean whitelistHarvest = CONFIG.getBool("Use Whitelist");
        public static Set<Block> whitelist = Golem.constructList(CONFIG.getString("Crop Whitelist"));

        private static Set<Block> constructList(String list) {
            HashSet<Block> set = new HashSet<Block>();
            String delim = list.contains(",") ? "," : " ";
            for (String str : list.split(delim)) {
                ResourceLocation location = ResourceLocation.tryParse((String)str);
                if (location == null) {
                    LOG.error("Resource location for {} not found!", (Object)str);
                    continue;
                }
                try {
                    Object object = BuiltInRegistries.ITEM.get(location);
                    if (object instanceof BlockItem) {
                        BlockItem block = (BlockItem)object;
                        set.add(block.getBlock());
                        continue;
                    }
                    if (BuiltInRegistries.BLOCK.get(location) == Blocks.AIR) continue;
                    set.add((Block)BuiltInRegistries.BLOCK.get(location));
                }
                catch (Exception e) {
                    LOG.error("Unable to find the block for the resource location!");
                }
            }
            return set;
        }
    }
}

