/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin;

import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.RecipeEssentialsClient;
import com.recipeessentials.config.CommonConfiguration;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RecipeBookComponent.class})
public class RecipebookSortingMixin {
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;
    @Shadow
    protected RecipeBookMenu menu;
    @Unique
    private RecipeHolder lastRecipe = null;

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void recipeessentials$onSelectedRecipe(double p_100294_, double p_100295_, int p_100296_, CallbackInfoReturnable<Boolean> cir) {
        RecipeHolder recipe;
        if (((CommonConfiguration)RecipeEssentials.config.getCommonConfig()).enableBetterRecipebookSorting && this.lastRecipe != (recipe = this.recipeBookPage.getLastClickedRecipe()) && recipe != null) {
            RecipeEssentialsClient.USED_GHOST_RECIPES.put((Object)recipe.id(), RecipeEssentialsClient.USED_GHOST_RECIPES.getOrDefault((Object)recipe.id(), 0) + 1);
            this.lastRecipe = recipe;
        }
    }

    @Inject(method={"updateCollections"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeBookPage;updateCollections(Ljava/util/List;Z)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void recipeessentials$sortCollection(boolean p_100383_, CallbackInfo ci, List<RecipeCollection> list, List<RecipeCollection> resultRecipes) {
        if (((CommonConfiguration)RecipeEssentials.config.getCommonConfig()).enableBetterRecipebookSorting) {
            resultRecipes.sort(Comparator.comparingInt(r -> {
                int sum = 0;
                for (RecipeHolder recipe : r.getRecipes()) {
                    sum += RecipeEssentialsClient.USED_GHOST_RECIPES.getOrDefault((Object)recipe.id(), 0);
                }
                return r.hasCraftable() ? sum + 1000 : sum;
            }).reversed());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void recipeessentials$onTick(CallbackInfo ci) {
        if (this.menu == null) {
            ci.cancel();
        }
    }
}

