/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace;

import java.util.List;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.recipes.RecipeSorter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JumboFurnaceUtils {
    public static int getJumboSmeltingBurnTime(ItemStack stack) {
        int jumboSmeltingBurnTime = stack.getBurnTime((RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get());
        return jumboSmeltingBurnTime >= 0 ? jumboSmeltingBurnTime : stack.getBurnTime(RecipeType.SMELTING);
    }

    public static IItemHandler copyItemHandler(IItemHandler itemHandler) {
        int slots = itemHandler.getSlots();
        ItemStackHandler copy = new ItemStackHandler(slots);
        for (int i = 0; i < slots; ++i) {
            copy.setStackInSlot(i, itemHandler.getStackInSlot(i).copy());
        }
        return copy;
    }

    public static void copyItemHandlerTo(IItemHandler from, IItemHandlerModifiable to) {
        int slots = to.getSlots();
        int fromSlots = from.getSlots();
        if (fromSlots < slots) {
            slots = fromSlots;
        }
        for (int i = 0; i < slots; ++i) {
            to.setStackInSlot(i, from.getStackInSlot(i));
        }
    }

    public static boolean canBeJumboFurnaceInput(Item item, Level level) {
        return !RecipeSorter.INSTANCE.getSortedFurnaceRecipesValidForInputs(List.of(item), level.getRecipeManager()).isEmpty();
    }
}

