/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.CrossPlatform;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.data.BetterStatus;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BetterCompatibilityChecker {
    private static BetterCompatibilityChecker INSTANCE;
    public static final CrossPlatform PLATFORM;
    public static final String MOD_ID = "bcc";
    private static final Logger LOGGER;
    @Nullable
    private static BetterStatus betterStatus;

    public static BetterCompatibilityChecker get() {
        if (INSTANCE == null) {
            INSTANCE = new BetterCompatibilityChecker();
        }
        return INSTANCE;
    }

    private BetterCompatibilityChecker() {
        LOGGER.info("Better Compatibility Checker starting");
    }

    public void init() {
    }

    public void onSetup(Consumer<BetterStatus> onSuccess) {
        LOGGER.info("Better Compatibility Checker setup");
        if (((Boolean)Config.useMetadata.get()).booleanValue()) {
            Path metaFile = PLATFORM.configPath().resolve("metadata.json");
            if (!Files.exists(metaFile, new LinkOption[0])) {
                LOGGER.error("No metadata.json found, falling back to config values");
            } else {
                try {
                    LOGGER.info("Loading metadata.json");
                    Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                    LOGGER.info("Loaded metadata.json - Modpack: {} | Version: {}", (Object)metadata.name, (Object)metadata.version.name);
                    BetterCompatibilityChecker.updateStatus(new BetterStatus(metadata.name, metadata.version.name, true));
                    onSuccess.accept(betterStatus);
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read metadata.json", (Throwable)e);
                }
            }
        }
        BetterCompatibilityChecker.updateStatus(new BetterStatus((String)Config.modpackName.get(), (String)Config.modpackVersion.get(), false));
        onSuccess.accept(betterStatus);
    }

    public static boolean comparePingData(BetterStatus otherStatus) {
        return otherStatus.name().equals(betterStatus.name()) && otherStatus.version().equals(betterStatus.version());
    }

    public static void updateStatus(BetterStatus newStatus) {
        betterStatus = newStatus;
    }

    @Nullable
    public static BetterStatus getBetterStatus() {
        return betterStatus;
    }

    static {
        PLATFORM = ServiceLoader.load(CrossPlatform.class).findFirst().orElseThrow();
        LOGGER = LogUtils.getLogger();
        betterStatus = null;
    }
}

