/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class RemplaceLootModifier
extends LootModifier {
    private final Item replacedItem;
    private final Item newItem;
    private final EntityType<?> entity;
    public static final Supplier<MapCodec<RemplaceLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> RemplaceLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("replaces").forGetter(RemplaceLootModifier::getReplacedItem)).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(RemplaceLootModifier::getNewItem)).and((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(RemplaceLootModifier::getEntity)).apply((Applicative)inst, RemplaceLootModifier::new)));

    public RemplaceLootModifier(LootItemCondition[] conditionsIn, Item replacedItem, Item newItem, EntityType<?> entity) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.newItem = newItem;
        this.entity = entity;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity != null && entity.getType() == this.entity) {
            int amountOfItems = generatedLoot.stream().filter(itemStack -> itemStack.getItem() == this.replacedItem).mapToInt(ItemStack::getCount).sum();
            generatedLoot.removeIf(itemStack -> itemStack.getItem() == this.replacedItem);
            generatedLoot.add((Object)new ItemStack((ItemLike)this.newItem, amountOfItems));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public Item getReplacedItem() {
        return this.replacedItem;
    }

    public Item getNewItem() {
        return this.newItem;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }
}

