/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.enchantment;

import com.soytutta.mynethersdelight.common.enchantment.PoachingFailureCase;
import com.soytutta.mynethersdelight.common.events.CommonEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biomes;
import vectorwing.farmersdelight.common.tag.ModTags;

public class PoachingFailureRegistry {
    private static final List<PoachingFailureCase> CASES = new ArrayList<PoachingFailureCase>();

    public static void register(PoachingFailureCase failureCase) {
        CASES.add(failureCase);
    }

    public static Optional<PoachingFailureCase> findCaseFor(Mob mob, ItemStack weapon) {
        return CASES.stream().filter(c -> c.matches(mob, weapon)).findFirst();
    }

    public static void registerAll() {
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.SPIDER, (EntityType<? extends Mob>)EntityType.CAVE_SPIDER, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, (mob, weapon) -> mob.level().random.nextFloat() < 0.4f, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.SHEEP, (EntityType<? extends Mob>)EntityType.WOLF, SoundEvents.WOLF_HOWL, (mob, weapon) -> !((Sheep)mob).isSheared() && mob.level().random.nextFloat() < 0.3f, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.FROG, (EntityType<? extends Mob>)EntityType.WITCH, SoundEvents.WITCH_CELEBRATE, (mob, weapon) -> mob.level().getBiome(mob.blockPosition()).is(Biomes.SWAMP) && mob.level().random.nextFloat() < 0.3f || weapon.is(ModTags.KNIVES) && mob.level().random.nextFloat() < 0.3f, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.BAT, (EntityType<? extends Mob>)EntityType.WITCH, SoundEvents.WITCH_CELEBRATE, (mob, weapon) -> mob.level().getBiome(mob.blockPosition()).is(Biomes.SWAMP) && mob.level().random.nextFloat() < 0.3f || weapon.is(ModTags.KNIVES) && mob.level().random.nextFloat() < 0.3f, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.ALLAY, (EntityType<? extends Mob>)EntityType.VEX, SoundEvents.EVOKER_PREPARE_SUMMON, (mob, weapon) -> true, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.HOGLIN, (EntityType<? extends Mob>)EntityType.ZOGLIN, SoundEvents.HOGLIN_CONVERTED_TO_ZOMBIFIED, (mob, weapon) -> true, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.HORSE, (EntityType<? extends Mob>)EntityType.ZOMBIE_HORSE, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, (mob, weapon) -> mob.level().random.nextFloat() < 0.4f || ((AbstractHorse)mob).isTamed() && mob.level().random.nextFloat() < 0.2f, (original, newMob) -> CommonEvent.transferFullHorseData((AbstractHorse)original, (AbstractHorse)newMob)));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.ZOMBIE_HORSE, (EntityType<? extends Mob>)EntityType.SKELETON_HORSE, SoundEvents.ZOMBIE_INFECT, (mob, weapon) -> mob.level().random.nextFloat() < 0.2f || ((AbstractHorse)mob).isTamed() && mob.level().random.nextFloat() < 0.1f, (original, newMob) -> CommonEvent.transferFullHorseData((AbstractHorse)original, (AbstractHorse)newMob)));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.ZOMBIE, (EntityType<? extends Mob>)EntityType.SKELETON, SoundEvents.ZOMBIE_INFECT, (mob, weapon) -> !(mob instanceof ZombieVillager) && !mob.isBaby() && mob.level().random.nextFloat() < 0.3f, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.VILLAGER, (EntityType<? extends Mob>)EntityType.ZOMBIE_VILLAGER, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, (mob, weapon) -> true, (original, newMob) -> {
            Villager villager = (Villager)original;
            ZombieVillager zombieVillager = (ZombieVillager)newMob;
            CompoundTag nbt = new CompoundTag();
            original.addAdditionalSaveData(nbt);
            nbt.remove("UUID");
            nbt.remove("Health");
            newMob.readAdditionalSaveData(nbt);
            zombieVillager.setVillagerData(villager.getVillagerData());
            CommonEvent.makeHostile(newMob, original.getLastHurtByMob());
        }));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.WOLF, (EntityType<? extends Mob>)EntityType.WOLF, SoundEvents.WOLF_GROWL, (mob, weapon) -> ((Wolf)mob).isTame() && mob.level().random.nextFloat() < 0.5f, (original, newMob) -> {
            CompoundTag nbt = new CompoundTag();
            original.addAdditionalSaveData(nbt);
            nbt.remove("UUID");
            nbt.remove("Health");
            newMob.readAdditionalSaveData(nbt);
            CommonEvent.transferBasicMobData(original, newMob);
            ((Wolf)newMob).setTame(false, true);
            CommonEvent.makeHostile(newMob, original.getLastHurtByMob());
        }));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.PIGLIN, (EntityType<? extends Mob>)EntityType.ZOMBIFIED_PIGLIN, SoundEvents.PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED, (mob, weapon) -> true, CommonEvent::transferDataAndMakeHostile));
        PoachingFailureRegistry.register(new PoachingFailureCase((EntityType<? extends Mob>)EntityType.PIGLIN_BRUTE, (EntityType<? extends Mob>)EntityType.ZOMBIFIED_PIGLIN, SoundEvents.PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED, (mob, weapon) -> true, CommonEvent::transferDataAndMakeHostile));
    }
}

