/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import java.util.Arrays;
import java.util.List;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.ShapeUtil;

public class Triangle
extends AbstractPolygon {
    private final double p1x;
    private final double p1z;
    private final double p2x;
    private final double p2z;
    private final double p3x;
    private final double p3z;

    public Triangle(Selection selection, boolean chunkAligned) {
        super(selection, chunkAligned);
        this.p1x = this.centerX + this.radiusX;
        this.p1z = this.centerZ + this.radiusX;
        this.p2x = this.centerX - this.radiusX;
        this.p2z = this.centerZ + this.radiusX;
        this.p3x = this.centerX;
        this.p3z = this.centerZ - this.radiusX;
    }

    @Override
    public List<Vector2> points() {
        return Arrays.asList(Vector2.of(this.p1x, this.p1z), Vector2.of(this.p2x, this.p2z), Vector2.of(this.p3x, this.p3z));
    }

    @Override
    public boolean isBounding(double x, double z) {
        if (!ShapeUtil.insideLine(this.p1x, this.p1z, this.p2x, this.p2z, x, z)) {
            return false;
        }
        if (!ShapeUtil.insideLine(this.p2x, this.p2z, this.p3x, this.p3z, x, z)) {
            return false;
        }
        return ShapeUtil.insideLine(this.p3x, this.p3z, this.p1x, this.p1z, x, z);
    }

    @Override
    public String name() {
        return "triangle";
    }
}

