/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.zoom.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import page.langeweile.ok_zoomer.zoom.overlays.ZoomOverlay;
import page.langeweile.ok_zoomer.zoom.transitions.EasedTransitionMode;

public class SpyglassZoomOverlay
implements ZoomOverlay {
    private final ResourceLocation textureId;
    private float scale;
    private boolean active;

    public SpyglassZoomOverlay(ResourceLocation textureId) {
        this.textureId = textureId;
        this.scale = 0.5f;
        this.active = false;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public boolean cancelOverlayRendering() {
        return true;
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker, EasedTransitionMode transitionMode) {
        int guiWidth = graphics.guiWidth();
        int guiHeight = graphics.guiHeight();
        float smallerLength = Math.min(guiWidth, guiHeight);
        float scaledSmallerLength = Math.min((float)guiWidth / smallerLength, (float)guiHeight / smallerLength) * this.scale;
        int width = Mth.floor((float)(smallerLength * scaledSmallerLength));
        int height = Mth.floor((float)(smallerLength * scaledSmallerLength));
        int x = (guiWidth - width) / 2;
        int y = (guiHeight - height) / 2;
        int borderX = x + width;
        int borderY = y + height;
        RenderSystem.enableBlend();
        graphics.blit(this.textureId, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
        graphics.fill(RenderType.guiOverlay(), 0, borderY, guiWidth, guiHeight, -16777216);
        graphics.fill(RenderType.guiOverlay(), 0, 0, guiWidth, y, -16777216);
        graphics.fill(RenderType.guiOverlay(), 0, y, x, borderY, -16777216);
        graphics.fill(RenderType.guiOverlay(), borderX, y, guiWidth, borderY, -16777216);
    }

    @Override
    public void tick(boolean active, double divisor, EasedTransitionMode transitionMode) {
        this.active = active;
    }

    @Override
    public void tickBeforeRender(DeltaTracker deltaTracker) {
        this.scale = !this.active ? 0.5f : Mth.lerp((float)(0.5f * deltaTracker.getGameTimeDeltaTicks()), (float)this.scale, (float)1.125f);
    }
}

