/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.utils;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final TagKey<Item> ZOOM_DEPENDENCIES_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ModUtils.id("zoom_dependencies"));
    public static final SoundEvent ZOOM_IN_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ModUtils.id("zoom.zoom_in"));
    public static final SoundEvent ZOOM_OUT_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ModUtils.id("zoom.zoom_out"));
    public static final SoundEvent SCROLL_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ModUtils.id("zoom.scroll"));
    public static int zoomStep = 0;
    private static Predicate<LocalPlayer> hasSpyglass = player -> player.isCreative();
    private static boolean safeSmartOcclusion = false;
    private static Float fadeModifier = null;

    public static void changeZoomDivisor(boolean increase) {
        Minecraft minecraft = Minecraft.getInstance();
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollResolution.value();
        int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollStepLimit.value();
        int lowerScrollStep = 0;
        int lastZoomStep = zoomStep;
        zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
        double divisor = 1.0;
        if (zoomStep != 0) {
            divisor = Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution);
            Zoom.setZoomDivisor(divisor);
        } else {
            Zoom.setZoomDivisor(1.0);
        }
        if (lastZoomStep != zoomStep && ((Boolean)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollSounds.value()).booleanValue()) {
            minecraft.player.playSound(SCROLL_SOUND, 1.0f, 1.0f);
        }
        if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.debugScrolling.value()).booleanValue()) {
            minecraft.player.displayClientMessage((Component)Component.literal((String)(zoomStep + " - " + divisor)), true);
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (!userPrompted && !((Boolean)OkZoomerConfigManager.CONFIG.zoomScrolling.forgetScrollStep.value()).booleanValue()) {
            return;
        }
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollResolution.value();
        zoomStep = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.defaultScrollStep.value();
        Zoom.setZoomDivisor(Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution));
    }

    public static void keepZoomStepsWithinBounds() {
        zoomStep = Mth.clamp((int)zoomStep, (int)0, (int)((Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollStepLimit.value()));
    }

    public static boolean hasSpyglass(LocalPlayer player) {
        return hasSpyglass.test(player);
    }

    public static void addSpyglassProvider(Predicate<LocalPlayer> provider) {
        hasSpyglass = hasSpyglass.or(provider);
    }

    public static void enableSafeSmartOcclusion() {
        safeSmartOcclusion = true;
    }

    public static boolean hasSmartOcclusion() {
        return (Boolean)OkZoomerConfigManager.CONFIG.appearance.smartOcclusion.value() != false && safeSmartOcclusion;
    }

    public static boolean canSeeDistantEntities() {
        return switch ((ConfigEnums.SeeDistantEntitiesModes)OkZoomerConfigManager.CONFIG.appearance.seeDistantEntities.value()) {
            default -> throw new MatchException(null, null);
            case ConfigEnums.SeeDistantEntitiesModes.SAFE -> safeSmartOcclusion;
            case ConfigEnums.SeeDistantEntitiesModes.ON -> true;
            case ConfigEnums.SeeDistantEntitiesModes.OFF -> false;
        };
    }

    public static Float getFadeModifier() {
        return fadeModifier;
    }

    public static void setFadeModifier(Float fadeModifier) {
        ZoomUtils.fadeModifier = fadeModifier;
    }
}

