/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.utils.ZoomUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickInstances(CallbackInfo info) {
        boolean zooming = Zoom.isZooming();
        if (zooming || Zoom.isTransitionActive() || Zoom.isModifierActive() || Zoom.isOverlayActive()) {
            double divisor = zooming ? Zoom.getZoomDivisor() : 1.0;
            Zoom.getTransitionMode().tick(zooming, divisor);
            if (Zoom.getMouseModifier() != null) {
                Zoom.getMouseModifier().tick(zooming);
            }
            if (Zoom.getZoomOverlay() != null) {
                Zoom.getZoomOverlay().tick(zooming, divisor, Zoom.getTransitionMode());
            }
        }
    }

    @ModifyExpressionValue(method={"renderLevel"}, at={@At(value="INVOKE", target="Ljava/lang/Integer;intValue()I", remap=false)})
    private int modifyCulling(int original) {
        if (!Zoom.isZooming() || !ZoomUtils.hasSmartOcclusion()) {
            return original;
        }
        return Mth.positiveCeilDiv((int)original, (int)Math.max(1, Mth.floor((double)Zoom.getZoomDivisor())));
    }

    @ModifyReturnValue(method={"getFov"}, at={@At(value="RETURN", ordinal=1)})
    private double modifyFov(double original, @Local(argsOnly=true) float partialTicks, @Local(argsOnly=true) boolean useFovSetting) {
        if (!Zoom.isTransitionActive() || !useFovSetting && !((Boolean)OkZoomerConfigManager.CONFIG.appearance.zoomHands.value()).booleanValue()) {
            return original;
        }
        return Zoom.getTransitionMode().applyZoom((float)original, partialTicks);
    }

    @ModifyExpressionValue(method={"bobView"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(FFF)F")})
    private float modifyBob(float bob, @Local(argsOnly=true) float delta) {
        if (!Zoom.isZooming() || !((Boolean)OkZoomerConfigManager.CONFIG.appearance.reduceViewBobbing.value()).booleanValue()) {
            return bob;
        }
        return Zoom.getTransitionMode().applyZoom(bob, delta);
    }
}

