/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config.screen.components;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class OkZoomerSelectionList
extends ContainerObjectSelectionList<Entry> {
    private final Screen screen;

    public OkZoomerSelectionList(Minecraft minecraft, int width, int height, int y, Screen screen) {
        super(minecraft, width, height, y, 25);
        this.screen = screen;
    }

    public int getRowWidth() {
        return 310;
    }

    public void addCategory(Component component) {
        this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(this, component, this.screen));
    }

    public void addButton(AbstractWidget button) {
        this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(button, this.screen));
    }

    public void addButton(AbstractWidget leftButton, AbstractWidget rightButton) {
        this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(leftButton, rightButton, this.screen));
    }

    class CategoryEntry
    extends Entry {
        private final StringWidget widget;

        private CategoryEntry(OkZoomerSelectionList this$0, Component title, Screen screen) {
            super(screen);
            this.widget = new StringWidget(title, ((OkZoomerSelectionList)this$0).minecraft.font);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.setPosition(this.screen.width / 2 - 155, top + 14);
            this.widget.render(graphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.widget);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widget);
        }
    }

    static class ButtonEntry
    extends Entry {
        private final AbstractWidget leftButton;
        private final AbstractWidget rightButton;
        private final List<AbstractWidget> buttons;

        public ButtonEntry(AbstractWidget button, Screen screen) {
            super(screen);
            button.setWidth(310);
            this.leftButton = button;
            this.rightButton = null;
            this.buttons = List.of(button);
        }

        public ButtonEntry(AbstractWidget leftButton, AbstractWidget rightButton, Screen screen) {
            super(screen);
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int x = this.screen.width / 2 - 155;
            int y = top;
            this.leftButton.setPosition(x, y + 2);
            this.leftButton.render(graphics, mouseX, mouseY, partialTick);
            if (this.rightButton != null) {
                this.rightButton.setPosition(x + 160, y + 2);
                this.rightButton.render(graphics, mouseX, mouseY, partialTick);
            }
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.buttons;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.buttons;
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final Screen screen;

        Entry(Screen screen) {
            this.screen = screen;
        }
    }
}

