/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config.screen.components;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.quiltmc.config.api.values.TrackedValue;
import page.langeweile.ok_zoomer.config.metadata.RangeSubset;

public class OkZoomerIntegerSlider
extends AbstractSliderButton {
    private final Component optionText;
    private final int minValue;
    private final int maxValue;
    private final Consumer<Integer> responder;
    private int internalValue;

    public OkZoomerIntegerSlider(TrackedValue<Integer> trackedValue, Component optionText, int x, int y, int width, int height, int value, Consumer<Integer> responder) {
        super(x, y, width, height, (Component)CommonComponents.optionNameValue((Component)optionText, (Component)Component.literal((String)String.valueOf(value))), 0.0);
        this.optionText = optionText;
        this.responder = responder;
        this.internalValue = value;
        int minValue = 0;
        int maxValue = 100;
        if (trackedValue.hasMetadata(RangeSubset.TYPE)) {
            RangeSubset.Range range = (RangeSubset.Range)trackedValue.metadata(RangeSubset.TYPE);
            minValue = range.min();
            maxValue = range.max();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = (double)Math.clamp((long)value, minValue, maxValue) / (double)(maxValue - minValue);
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.optionText, (Component)Component.literal((String)String.valueOf(this.internalValue))));
    }

    protected void applyValue() {
        int value = Mth.floor((double)Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue));
        this.responder.accept(value);
        this.internalValue = value;
    }
}

