/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config.screen.components;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.quiltmc.config.api.values.TrackedValue;
import page.langeweile.ok_zoomer.config.metadata.RangeSubset;

public class OkZoomerFloatSlider
extends AbstractSliderButton {
    private final Component optionText;
    private final double minValue;
    private final double maxValue;
    private final Consumer<Float> responder;
    private float internalValue;

    public OkZoomerFloatSlider(TrackedValue<Float> trackedValue, Component optionText, int x, int y, int width, int height, float value, Consumer<Float> responder) {
        super(x, y, width, height, (Component)CommonComponents.optionNameValue((Component)optionText, (Component)Component.literal((String)String.valueOf(value))), 0.0);
        this.optionText = optionText;
        this.responder = responder;
        this.internalValue = value;
        double minValue = 0.0;
        double maxValue = 100.0;
        if (trackedValue.hasMetadata(RangeSubset.TYPE)) {
            RangeSubset.Range range = (RangeSubset.Range)trackedValue.metadata(RangeSubset.TYPE);
            minValue = range.min();
            maxValue = range.max();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = (Math.clamp((double)value, minValue, maxValue) - minValue) / (maxValue - minValue);
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.optionText, (Component)Component.literal((String)String.valueOf(this.internalValue))));
    }

    protected void applyValue() {
        float value = (float)((double)Mth.floor((double)(Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue) * 10.0)) / 10.0);
        this.responder.accept(Float.valueOf(value));
        this.internalValue = value;
    }
}

