/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfig;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;
import page.langeweile.ok_zoomer.zoom.modifiers.CinematicCameraMouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.ContainingMouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.ZoomDivisorMouseModifier;
import page.langeweile.ok_zoomer.zoom.overlays.SpyglassZoomOverlay;
import page.langeweile.ok_zoomer.zoom.overlays.ZoomerZoomOverlay;
import page.langeweile.ok_zoomer.zoom.transitions.EasedTransitionMode;
import page.langeweile.wrench_wrapper.api.WrenchWrapper;

public class OkZoomerConfigManager {
    public static final OkZoomerConfig CONFIG = (OkZoomerConfig)WrenchWrapper.create((String)"ok_zoomer", (String)"config", OkZoomerConfig.class);

    public static void init() {
        OkZoomerConfigManager.configureZoomInstance();
        CONFIG.registerCallback(config -> OkZoomerConfigManager.configureZoomInstance());
    }

    public static void configureZoomInstance() {
        Zoom.setTransitionMode(new EasedTransitionMode(OkZoomerConfigManager.getZoomTransitionOperator((ConfigEnums.ZoomTransitionModes)OkZoomerConfigManager.CONFIG.zoomTransition.startTransition.value()), OkZoomerConfigManager.getZoomTransitionOperator((ConfigEnums.ZoomTransitionModes)OkZoomerConfigManager.CONFIG.zoomTransition.endTransition.value()), OkZoomerConfigManager.getZoomTransitionOperator((ConfigEnums.ZoomTransitionModes)OkZoomerConfigManager.CONFIG.zoomScrolling.transition.value()), OkZoomerConfigManager.getStartTransitionTicks(), OkZoomerConfigManager.getEndTransitionTicks(), OkZoomerConfigManager.getScrollTransitionTicks(), (Boolean)OkZoomerConfigManager.CONFIG.zoomTransition.invertStartTransition.value(), (Boolean)OkZoomerConfigManager.CONFIG.zoomTransition.invertEndTransition.value()));
        OkZoomerConfigManager.configureZoomModifier();
        ResourceLocation overlayTextureId = OkZoomerConfigManager.CONFIG.appearance.zoomOverlay.value() == ConfigEnums.ZoomOverlays.SPYGLASS ? ResourceLocation.withDefaultNamespace((String)"textures/misc/spyglass_scope.png") : ModUtils.id("textures/misc/zoom_overlay.png");
        Zoom.setZoomOverlay(switch ((ConfigEnums.ZoomOverlays)OkZoomerConfigManager.CONFIG.appearance.zoomOverlay.value()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        });
    }

    public static FloatUnaryOperator getZoomTransitionOperator(ConfigEnums.ZoomTransitionModes mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case ConfigEnums.ZoomTransitionModes.INSTANT -> f -> 1.0f;
            case ConfigEnums.ZoomTransitionModes.LINEAR -> f -> f;
            case ConfigEnums.ZoomTransitionModes.SMOOTH -> f -> (float)(1.0 - Math.pow(2.0, -10.0 * (double)f));
            case ConfigEnums.ZoomTransitionModes.SINE -> f -> (float)(1.0 - Math.cos((double)f * Math.PI / 2.0));
            case ConfigEnums.ZoomTransitionModes.BALANCED -> f -> (float)(1.0 - Math.pow(1.0 - (double)f, 3.0));
            case ConfigEnums.ZoomTransitionModes.SPRING -> f -> (float)(Math.pow(2.0, -10.0f * f) * (double)Mth.sin((float)((f * 10.0f - 0.75f) * 1.5f)) + 1.0);
        };
    }

    public static int getStartTransitionTicks() {
        return OkZoomerConfigManager.CONFIG.zoomTransition.startTransition.value() != ConfigEnums.ZoomTransitionModes.INSTANT ? (Integer)OkZoomerConfigManager.CONFIG.zoomTransition.startTransitionTicks.value() : 0;
    }

    public static int getEndTransitionTicks() {
        return OkZoomerConfigManager.CONFIG.zoomTransition.endTransition.value() != ConfigEnums.ZoomTransitionModes.INSTANT ? (Integer)OkZoomerConfigManager.CONFIG.zoomTransition.endTransitionTicks.value() : 0;
    }

    public static int getScrollTransitionTicks() {
        return OkZoomerConfigManager.CONFIG.zoomScrolling.transition.value() != ConfigEnums.ZoomTransitionModes.INSTANT ? (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.transitionTicks.value() : 0;
    }

    public static void configureZoomModifier() {
        boolean cinematicCamera = (Boolean)OkZoomerConfigManager.CONFIG.controls.cinematicCamera.value();
        boolean reduceSensitivity = (Boolean)OkZoomerConfigManager.CONFIG.controls.reduceSensitivity.value();
        if (cinematicCamera) {
            CinematicCameraMouseModifier cinematicModifier = new CinematicCameraMouseModifier(((Float)OkZoomerConfigManager.CONFIG.controls.cinematicCameraSpeed.value()).floatValue());
            Zoom.setMouseModifier(reduceSensitivity ? new ContainingMouseModifier(cinematicModifier, new ZoomDivisorMouseModifier()) : cinematicModifier);
        } else {
            Zoom.setMouseModifier(reduceSensitivity ? new ZoomDivisorMouseModifier() : null);
        }
    }
}

