/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.smart_ingredient_sync;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import org.embeddedt.modernfix.neoforge.packet.SmartIngredientSyncPayload;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/world/item/crafting/Ingredient$1"})
public abstract class IngredientMixin {
    @Inject(method={"encode(Lnet/minecraft/network/RegistryFriendlyByteBuf;Lnet/minecraft/world/item/crafting/Ingredient;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack;LIST_STREAM_CODEC:Lnet/minecraft/network/codec/StreamCodec;")}, cancellable=true)
    private void checkForVanillaTagIngredient(RegistryFriendlyByteBuf buf, Ingredient ingredient, CallbackInfo ci) {
        Ingredient.Value value;
        if (!SmartIngredientSyncPayload.CLIENT_HAS_SMART_INGREDIENT_SYNC.get().booleanValue() || ingredient.isCustom()) {
            return;
        }
        Ingredient.Value[] values = ingredient.getValues();
        if (values.length == 1 && (value = values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            Optional optionalHolderSet = BuiltInRegistries.ITEM.getTag(tagValue.tag());
            if (optionalHolderSet.isEmpty()) {
                return;
            }
            ci.cancel();
            buf.writeVarInt(-2);
            buf.writeResourceLocation(tagValue.tag().location());
        }
    }

    @Inject(method={"decode(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lnet/minecraft/world/item/crafting/Ingredient;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void decodeSmartIngredient(RegistryFriendlyByteBuf buf, CallbackInfoReturnable<Ingredient> cir) {
        int readerIndex = buf.readerIndex();
        int sizeId = buf.readVarInt();
        if (sizeId == -2) {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)buf.readResourceLocation());
            cir.setReturnValue((Object)Ingredient.of((TagKey)tagKey));
        } else {
            buf.readerIndex(readerIndex);
        }
    }
}

