/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ModIdentification;

public class OverlayRenderer {
    public static final TooltipRect rect = new TooltipRect();
    public static float ticks;
    public static boolean shown;
    public static float alpha;
    private static BoxElement lingerTooltip;
    private static float disappearTicks;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().rootElement == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.isDown()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || Minecraft.getInstance().screen instanceof BaseOptionsScreen || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(BoxElement box) {
        Minecraft mc = Minecraft.getInstance();
        if (!ClientProxy.shouldShowWithGui(mc, mc.screen)) {
            return false;
        }
        box.updateExpectedRect(rect);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        Screen screen = mc.screen;
        if (screen instanceof PreviewOptionsScreen) {
            double y;
            PreviewOptionsScreen optionsScreen = (PreviewOptionsScreen)screen;
            if (optionsScreen.forcePreviewOverlay()) {
                return true;
            }
            if (!general.previewOverlay) {
                return false;
            }
            Window window = mc.getWindow();
            double x = mc.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
            if (OverlayRenderer.rect.expectedRect.contains((int)x, (int)(y = mc.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight()))) {
                return false;
            }
        }
        if (mc.getOverlay() != null || mc.options.hideGui) {
            return false;
        }
        return !mc.gui.getTabList().visible || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(GuiGraphics guiGraphics, float delta) {
        boolean show;
        ticks += delta;
        shown = false;
        BoxElement root = WailaTickHandler.instance().rootElement;
        if (root == null && PreviewOptionsScreen.isAdjustingPosition()) {
            Tooltip tooltip = new Tooltip();
            tooltip.add((Component)IThemeHelper.get().title(Blocks.GRASS_BLOCK.getName()));
            tooltip.add((Component)IThemeHelper.get().modName(ModIdentification.getModName(Blocks.GRASS_BLOCK)));
            root = new BoxElement(tooltip, IThemeHelper.get().theme().tooltipStyle);
            root.tag(JadeIds.ROOT);
            root.setThemeIcon(ItemStackElement.of(new ItemStack((ItemLike)Blocks.GRASS_BLOCK)), IThemeHelper.get().theme());
            root.updateExpectedRect(rect);
            show = true;
        } else {
            show = OverlayRenderer.shouldShow();
        }
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (root != null) {
            lingerTooltip = root;
        }
        if (root == null && lingerTooltip != null) {
            if ((disappearTicks += delta) < overlay.getDisappearingDelay()) {
                root = lingerTooltip;
                show = true;
            }
        } else {
            disappearTicks = 0.0f;
        }
        if (overlay.getAnimation() && lingerTooltip != null) {
            root = lingerTooltip;
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (root == null) {
            return;
        }
        if (!(!(alpha < 0.1f) && OverlayRenderer.shouldShowImmediately(root) || PreviewOptionsScreen.isAdjustingPosition())) {
            lingerTooltip = null;
            OverlayRenderer.rect.rect.setWidth(0);
            WailaTickHandler.clearLastNarration();
            return;
        }
        Minecraft.getInstance().getProfiler().push("Jade Overlay");
        OverlayRenderer.renderOverlay(root, guiGraphics);
        Minecraft.getInstance().getProfiler().pop();
    }

    public static void renderOverlay(BoxElement root, GuiGraphics guiGraphics) {
        root.updateRect(rect);
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.instance().beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(root, rect, guiGraphics, ObjectDataCenter.get())) continue;
            return;
        }
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        float z = screen == null ? 1.0f : (ClientProxy.shouldShowAfterGui(mc, screen) ? 100.0f : -999.0f);
        matrixStack.translate((float)OverlayRenderer.rect.rect.getX(), (float)OverlayRenderer.rect.rect.getY(), z);
        float scale = OverlayRenderer.rect.scale;
        if (scale != 1.0f) {
            matrixStack.scale(scale, scale, 1.0f);
        }
        RenderSystem.enableBlend();
        float maxWidth = OverlayRenderer.rect.rect.getWidth();
        float maxHeight = OverlayRenderer.rect.rect.getHeight();
        maxWidth /= scale;
        maxHeight /= scale;
        if (root.getStyle().hasRoundCorner()) {
            maxWidth -= 2.0f;
            maxHeight -= 2.0f;
        }
        root.render(guiGraphics, 0.0f, 0.0f, maxWidth, maxHeight);
        WailaClientRegistration.instance().afterRenderCallback.call(callback -> callback.afterRender(root, rect, guiGraphics, ObjectDataCenter.get()));
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        matrixStack.popPose();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            WailaTickHandler.narrate(root.getTooltip(), true);
        }
        shown = true;
    }

    public static void clearState() {
        lingerTooltip = null;
        WailaTickHandler.clearLastNarration();
    }
}

