/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.util;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.config.TeleConfig;
import it.unimi.dsi.fastutil.longs.Long2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class CakeTeleportHelper {
    private static final Object2ObjectMap<ResourceKey<Level>, LevelTeleportFinder> LEVEL_TELEPORTERS = (Object2ObjectMap)Util.make((Object)new Object2ObjectOpenHashMap(), map -> map.put((Object)ServerLevel.END, (entity, destWorld, minMaxBounds, cacheMap) -> CakeTeleportHelper.toEnd(entity, destWorld)));

    @Nullable
    public static DimensionTransition getCakeTeleportData(ServerLevel destWorld, Entity entity) {
        entity.fallDistance = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 200, false, false));
        }
        BlockPos spawnPos = CakeTeleportHelper.getDimensionPosition(entity, (ResourceKey<Level>)destWorld.dimension());
        Long2BooleanArrayMap safeLocation = new Long2BooleanArrayMap();
        Pair minMaxBounds = CakeTeleportHelper.customCompatBounds(destWorld).mapFirst(min -> Math.max(min, destWorld.getMinBuildHeight())).mapSecond(max -> Math.min(max, destWorld.getMaxBuildHeight()));
        if (spawnPos != null && destWorld.getBlockState(spawnPos.relative(Direction.DOWN)).isSolid() && CakeTeleportHelper.isPositionSafe(entity, destWorld, spawnPos, safeLocation, (Pair<Integer, Integer>)minMaxBounds)) {
            return CakeTeleportHelper.postProcessAndMake(destWorld, spawnPos, entity);
        }
        @Nullable DimensionTransition levelInfo = ((LevelTeleportFinder)LEVEL_TELEPORTERS.getOrDefault((Object)destWorld.dimension(), CakeTeleportHelper::searchAroundAndDown)).determineTeleportLocation(entity, destWorld, (Pair<Integer, Integer>)minMaxBounds, safeLocation);
        if (levelInfo != null) {
            return levelInfo;
        }
        BlockPos teleportPos = destWorld.getWorldBorder().isWithinBounds(entity.blockPosition()) && (Integer)minMaxBounds.getFirst() < entity.blockPosition().getY() - 1 && (float)((Integer)minMaxBounds.getSecond()).intValue() > (float)entity.blockPosition().getY() + entity.getBbHeight() + 1.0f ? entity.blockPosition() : new BlockPos(0, Math.max((Integer)minMaxBounds.getFirst(), 70), 0);
        float halfWidth = entity.getBbWidth() / 2.0f;
        int minX = Mth.floor((float)((float)teleportPos.getX() - halfWidth - 1.0f));
        int minY = teleportPos.getY() - 1;
        int minZ = Mth.floor((float)((float)teleportPos.getZ() - halfWidth - 1.0f));
        int maxX = Mth.ceil((float)((float)teleportPos.getX() + halfWidth + 1.0f));
        int maxY = Mth.ceil((float)((float)teleportPos.getY() + entity.getBbHeight() + 1.0f));
        int maxZ = Mth.ceil((float)((float)teleportPos.getZ() + halfWidth + 1.0f));
        for (BlockPos pedestalPos : BlockPos.betweenClosed((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState pedestalState;
            if (!destWorld.getWorldBorder().isWithinBounds(pedestalPos) || (pedestalState = destWorld.getBlockState(pedestalPos)).getBlock() instanceof BlockCakeBase) continue;
            if (pedestalPos.getY() == minY && !pedestalState.isSolid()) {
                destWorld.setBlockAndUpdate(pedestalPos, Blocks.OBSIDIAN.defaultBlockState());
                continue;
            }
            if (!(pedestalPos.getY() != maxY && pedestalPos.getX() != minX && pedestalPos.getX() != maxX && pedestalPos.getZ() != minZ && pedestalPos.getZ() != maxZ || pedestalState.isSolid())) {
                destWorld.setBlockAndUpdate(pedestalPos, Blocks.COBBLESTONE.defaultBlockState());
                continue;
            }
            if (pedestalState.getBlock().isPossibleToRespawnInThis(pedestalState)) continue;
            destWorld.setBlockAndUpdate(pedestalPos, Blocks.AIR.defaultBlockState());
        }
        return CakeTeleportHelper.postProcessAndMake(destWorld, teleportPos, entity);
    }

    @Nullable
    private static DimensionTransition searchAroundAndDown(Entity entity, ServerLevel destWorld, Pair<Integer, Integer> minMaxBounds, Long2BooleanArrayMap cacheMap) {
        double dimensionScale = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)destWorld.dimensionType());
        BlockPos spawnPos = destWorld.getWorldBorder().clampToBounds((double)entity.blockPosition().getX() * dimensionScale, (double)entity.blockPosition().getY(), (double)entity.blockPosition().getZ() * dimensionScale).atY(Math.min((Integer)minMaxBounds.getSecond(), destWorld.getMinBuildHeight() + destWorld.getLogicalHeight()) - 1);
        for (BlockPos.MutableBlockPos checkPos : BlockPos.spiralAround((BlockPos)spawnPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            destWorld.getChunk((BlockPos)checkPos);
            for (int heightY = Math.min(spawnPos.getY(), destWorld.getHeight(Heightmap.Types.MOTION_BLOCKING, checkPos.getX(), checkPos.getZ())); heightY > (Integer)minMaxBounds.getFirst(); --heightY) {
                checkPos.setY(heightY);
                if (!destWorld.getBlockState(checkPos.immutable().relative(Direction.DOWN)).isSolid() || !CakeTeleportHelper.isPositionSafe(entity, destWorld, (BlockPos)checkPos, cacheMap, minMaxBounds)) continue;
                return CakeTeleportHelper.postProcessAndMake(destWorld, (BlockPos)checkPos, entity);
            }
        }
        return null;
    }

    @Deprecated
    private static DimensionTransition toEnd(Entity entity, ServerLevel destWorld) {
        BlockPos teleportPos = ServerLevel.END_SPAWN_POINT;
        Vec3 vec3 = teleportPos.getBottomCenter();
        EndPlatformFeature.createEndPlatform((ServerLevelAccessor)destWorld, (BlockPos)BlockPos.containing((Position)vec3).below(), (boolean)true);
        return CakeTeleportHelper.postProcessAndMake(destWorld, teleportPos, entity);
    }

    private static boolean isPositionSafe(Entity entity, ServerLevel destWorld, BlockPos checkPos, Long2BooleanArrayMap cacheMap, Pair<Integer, Integer> minMaxBounds) {
        float halfWidth = entity.getBbWidth() / 2.0f;
        for (BlockPos entityBoxPos : BlockPos.betweenClosed((int)Math.round((float)checkPos.getX() - halfWidth), (int)checkPos.getY(), (int)Math.round((float)checkPos.getZ() - halfWidth), (int)Math.round((float)checkPos.getX() + halfWidth), (int)Math.round((float)checkPos.getY() + entity.getBbHeight()), (int)Math.round((float)checkPos.getZ() + halfWidth))) {
            if (cacheMap.computeIfAbsent(entityBoxPos.asLong(), c -> {
                if (!destWorld.getWorldBorder().isWithinBounds(entityBoxPos) || (Integer)minMaxBounds.getFirst() >= entityBoxPos.getY()) {
                    return false;
                }
                BlockState entityBoxState = destWorld.getBlockState(entityBoxPos);
                return entityBoxState.getBlock().isPossibleToRespawnInThis(entityBoxState);
            })) continue;
            return false;
        }
        return true;
    }

    public static void addDimensionPosition(Entity entityIn, ResourceKey<Level> dim, BlockPos position) {
        BlockPos usedPos;
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleportHelper.getTag(entityData);
        ResourceLocation dimLocation = dim.location();
        if (dim == Level.END) {
            BlockPos spawnPlatform;
            usedPos = spawnPlatform = ServerLevel.END_SPAWN_POINT;
            data.putLong("telepastries:" + String.valueOf(dimLocation), spawnPlatform.asLong());
        } else {
            Component name = entityIn instanceof Player ? entityIn.getDisplayName() : entityIn.getName();
            usedPos = position;
            data.putLong("telepastries:" + String.valueOf(dimLocation), position.asLong());
        }
        TelePastries.LOGGER.debug("Setting {}'s position of {} to: {}", new Object[]{CakeTeleportHelper.getEntityName(entityIn), dimLocation, usedPos});
        entityData.put("PlayerPersisted", (Tag)data);
    }

    private static String getEntityName(Entity entityIn) {
        Component name;
        Component component = name = entityIn instanceof Player ? entityIn.getDisplayName() : entityIn.getName();
        if (name == null) {
            name = Component.literal((String)entityIn.getType().toString());
        }
        return name.getString();
    }

    @Nullable
    public static BlockPos getDimensionPosition(Entity entityIn, ResourceKey<Level> dim) {
        ResourceLocation dimLocation;
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleportHelper.getTag(entityData);
        if (data.contains("telepastries:" + String.valueOf(dimLocation = dim.location()))) {
            BlockPos dimPos = BlockPos.of((long)data.getLong("telepastries:" + String.valueOf(dimLocation)));
            TelePastries.LOGGER.debug("Found {}'s position of {} to: {}", new Object[]{CakeTeleportHelper.getEntityName(entityIn), dimLocation, dimPos});
            return dimPos;
        }
        TelePastries.LOGGER.debug("Could not find {}'s previous location. Using current location", (Object)CakeTeleportHelper.getEntityName(entityIn));
        return null;
    }

    private static CompoundTag getTag(CompoundTag tag) {
        if (tag == null || !tag.contains("PlayerPersisted")) {
            return new CompoundTag();
        }
        return tag.getCompound("PlayerPersisted");
    }

    private static Pair<Integer, Integer> customCompatBounds(ServerLevel destWorld) {
        ResourceLocation customLocation3;
        ResourceLocation customLocation2;
        ResourceLocation customLocation = ResourceLocation.tryParse((String)((String)TeleConfig.COMMON.customCakeDimension.get()));
        if (customLocation != null) {
            ResourceKey customWorldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)customLocation);
            if (destWorld.dimension() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCakeMinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCakeMaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        if ((customLocation2 = ResourceLocation.tryParse((String)((String)TeleConfig.COMMON.customCake2Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)customLocation2);
            if (destWorld.dimension() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake2MinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCake2MaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        if ((customLocation3 = ResourceLocation.tryParse((String)((String)TeleConfig.COMMON.customCake3Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)customLocation3);
            if (destWorld.dimension() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake3MinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCake3MaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        return Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
    }

    private static DimensionTransition postProcessAndMake(ServerLevel destWorld, BlockPos pos, Entity entity) {
        ServerPlayer serverPlayer;
        if (destWorld.dimension() == Level.OVERWORLD && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)entity;
            serverPlayer2.setRespawnPosition(Level.OVERWORLD, pos, serverPlayer2.getYRot(), true, false);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            ResourceKey twilightKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_forest"));
            if (destWorld.dimension() == twilightKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.setRespawnPosition(twilightKey, pos, serverPlayer.getYRot(), true, false);
            }
        }
        if (ModList.get().isLoaded("lostcities")) {
            ResourceKey lostCityKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lostcities", (String)"lostcity"));
            if (destWorld.dimension() == lostCityKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.setRespawnPosition(lostCityKey, pos, serverPlayer.getYRot(), true, false);
            }
        }
        return CakeTeleportHelper.makePortalInfo(destWorld, entity, pos.getX(), pos.getY(), pos.getZ());
    }

    private static DimensionTransition makePortalInfo(ServerLevel destination, Entity entity, double x, double y, double z) {
        return CakeTeleportHelper.makePortalInfo(destination, entity, new Vec3(x, y, z));
    }

    private static DimensionTransition makePortalInfo(ServerLevel destination, Entity entity, Vec3 pos) {
        return new DimensionTransition(destination, pos, Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
    }

    @FunctionalInterface
    static interface LevelTeleportFinder {
        @Nullable
        public DimensionTransition determineTeleportLocation(Entity var1, ServerLevel var2, Pair<Integer, Integer> var3, Long2BooleanArrayMap var4);
    }
}

