/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.generator;

import com.mrbysco.telepastries.generator.client.PastryBlockStateProvider;
import com.mrbysco.telepastries.generator.client.PastryItemModelProvider;
import com.mrbysco.telepastries.generator.client.PastryLanguageProvider;
import com.mrbysco.telepastries.generator.server.PastryLootProvider;
import com.mrbysco.telepastries.generator.server.PastryRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PastriesGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new PastryLootProvider(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new PastryRecipeProvider(packOutput, lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PastryBlockStateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new PastryItemModelProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new PastryLanguageProvider(packOutput));
        }
    }
}

