/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake.compat;

import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.config.TeleConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;

public class BlockLostCityCake
extends BlockCakeBase {
    public BlockLostCityCake(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (ModList.get().isLoaded("lostcities")) {
            return super.useItemOn(stack, state, level, pos, player, hand, result);
        }
        if (player.getUsedItemHand() == hand && !level.isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"telepastries.pastry.support.disabled", (Object[])new Object[]{"lostcities"}).withStyle(ChatFormatting.RED));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public boolean isRefillItem(ItemStack stack) {
        List items = (List)TeleConfig.COMMON.lostCitiesCakeRefillItem.get();
        if (items.isEmpty()) {
            return false;
        }
        ResourceLocation registryLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return registryLocation != null && items.contains(registryLocation.toString());
    }

    @Override
    public ResourceKey<Level> getCakeWorld() {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lostcities", (String)"lostcity"));
    }

    @Override
    public boolean consumeCake() {
        return (Boolean)TeleConfig.COMMON.consumeLostCitiesCake.get();
    }
}

