/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake;

import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.config.TeleConfig;
import com.mrbysco.telepastries.util.CakeTeleportHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BlockEndCake
extends BlockCakeBase {
    public BlockEndCake(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void teleportToDimension(LevelAccessor levelAccessor, BlockPos pos, Player player) {
        if (player != null && !(player instanceof FakePlayer) && player.isAlive() && !levelAccessor.isClientSide() && levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (!player.isPassenger() && !player.isVehicle() && player.canChangeDimensions(player.level(), (Level)serverLevel)) {
                ServerLevel destinationWorld;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MinecraftServer server = player.getServer();
                ServerLevel serverLevel2 = destinationWorld = server != null ? server.getLevel(this.getCakeWorld()) : null;
                if (destinationWorld == null) {
                    return;
                }
                CakeTeleportHelper.addDimensionPosition((Entity)serverPlayer, (ResourceKey<Level>)serverPlayer.level().dimension(), serverPlayer.blockPosition());
                DimensionTransition transition = CakeTeleportHelper.getCakeTeleportData(destinationWorld, (Entity)serverPlayer);
                serverPlayer.changeDimension(transition);
            }
        }
    }

    @Override
    public boolean isRefillItem(ItemStack stack) {
        List items = (List)TeleConfig.COMMON.endCakeRefillItems.get();
        if (items.isEmpty()) {
            return false;
        }
        ResourceLocation registryLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return registryLocation != null && items.contains(registryLocation.toString());
    }

    @Override
    public ResourceKey<Level> getCakeWorld() {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"the_end"));
    }

    @Override
    public boolean consumeCake() {
        return (Boolean)TeleConfig.COMMON.consumeEndCake.get();
    }
}

