/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake;

import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.BlockPastryBase;
import com.mrbysco.telepastries.config.TeleConfig;
import com.mrbysco.telepastries.util.CakeTeleportHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BlockCakeBase
extends BlockPastryBase {
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public BlockCakeBase(BlockBehaviour.Properties properties) {
        super(properties.strength(0.5f).sound(SoundType.WOOL).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)BITES)];
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (this.consumeCake() && this.isRefillItem(stack)) {
            int i = (Integer)state.getValue((Property)BITES);
            if (i > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i - 1)), 3);
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        } else if (this.canTeleportTo(level.dimension().location(), this.getCakeWorld().location())) {
            if (((Boolean)TeleConfig.COMMON.resetPastry.get()).booleanValue() && this.isResetItem(stack)) {
                if (level.isClientSide) {
                    this.removeDimensionPosition((ServerPlayer)player, this.getCakeWorld());
                }
                if (stack.getItem() == Items.MILK_BUCKET && !player.getAbilities().instabuild) {
                    stack.shrink(1);
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
            } else {
                this.eatSlice((LevelAccessor)level, pos, state, player);
            }
        } else {
            if (level.dimension().location().equals((Object)this.getCakeWorld().location())) {
                player.displayClientMessage((Component)Component.translatable((String)"telepastries.same_dimension"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"telepastries.teleport_restricted"), true);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.FAIL;
    }

    public boolean canTeleportTo(ResourceLocation location, ResourceLocation toLocation) {
        if (((Boolean)TeleConfig.COMMON.disableHopping.get()).booleanValue()) {
            ResourceLocation overworldLocation = Level.OVERWORLD.location();
            if (location.equals((Object)overworldLocation)) {
                return !location.equals((Object)toLocation);
            }
            return toLocation.equals((Object)overworldLocation) && !location.equals((Object)overworldLocation);
        }
        return !location.equals((Object)toLocation);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (((Boolean)TeleConfig.COMMON.disableHopping.get()).booleanValue()) {
            ResourceLocation overworldLocation = Level.OVERWORLD.location();
            ResourceLocation worldLocation = ((Level)worldIn).dimension().location();
            if (worldLocation.equals((Object)overworldLocation)) {
                return !this.getCakeWorld().location().equals((Object)overworldLocation);
            }
            return this.getCakeWorld().location().equals((Object)overworldLocation);
        }
        return super.canSurvive(state, worldIn, pos);
    }

    private InteractionResult eatSlice(LevelAccessor levelAccessor, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(((Boolean)TeleConfig.COMMON.ignoreHunger.get()).booleanValue())) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(2, 0.1f);
        if (this.consumeCake() && !player.getAbilities().instabuild) {
            int i = (Integer)state.getValue((Property)BITES);
            levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            if (i < 6) {
                levelAccessor.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                levelAccessor.removeBlock(pos, false);
            }
        }
        if (!levelAccessor.isClientSide()) {
            if (!CommonHooks.onTravelToDimension((Entity)player, this.getCakeWorld())) {
                return InteractionResult.FAIL;
            }
            this.teleportToDimension(levelAccessor, pos, player);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isResetItem(ItemStack stack) {
        List items = (List)TeleConfig.COMMON.resetItems.get();
        if (items.isEmpty()) {
            return false;
        }
        ResourceLocation registryLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return registryLocation != null && items.contains(registryLocation.toString());
    }

    public void teleportToDimension(LevelAccessor levelAccessor, BlockPos pos, Player player) {
        if (player != null && !(player instanceof FakePlayer) && player.isAlive() && !levelAccessor.isClientSide() && levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (!player.isPassenger() && !player.isVehicle() && player.canChangeDimensions(player.level(), (Level)serverLevel)) {
                ServerLevel destinationWorld;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MinecraftServer server = player.getServer();
                ServerLevel serverLevel2 = destinationWorld = server != null ? server.getLevel(this.getCakeWorld()) : null;
                if (destinationWorld == null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"telepastries.pastry.custom.invalid", (Object[])new Object[]{this.getCakeWorld().location()}).withStyle(ChatFormatting.RED));
                    TelePastries.LOGGER.error("Destination of cake invalid {} isn't known", (Object)this.getCakeWorld().location());
                    return;
                }
                CakeTeleportHelper.addDimensionPosition((Entity)serverPlayer, (ResourceKey<Level>)serverPlayer.level().dimension(), serverPlayer.blockPosition());
                DimensionTransition transition = CakeTeleportHelper.getCakeTeleportData(destinationWorld, (Entity)serverPlayer);
                serverPlayer.changeDimension(transition);
            }
        }
    }

    public boolean isRefillItem(ItemStack stack) {
        return false;
    }

    public ResourceKey<Level> getCakeWorld() {
        return Level.OVERWORLD;
    }

    public boolean consumeCake() {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.getValue((Property)BITES)) * 2;
    }

    protected void removeDimensionPosition(ServerPlayer player, ResourceKey<Level> dim) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = this.getTag(playerData);
        if (data.contains("telepastries:" + String.valueOf(dim.location()))) {
            data.remove("telepastries:" + String.valueOf(dim.location()));
            player.sendSystemMessage((Component)Component.translatable((String)"telepastries.pastry.reset.complete", (Object[])new Object[]{dim.location()}));
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"telepastries.pastry.reset.failed", (Object[])new Object[]{dim.location()}));
        }
        playerData.put("PlayerPersisted", (Tag)data);
    }

    protected CompoundTag getTag(CompoundTag tag) {
        if (tag == null || !tag.contains("PlayerPersisted")) {
            return new CompoundTag();
        }
        return tag.getCompound("PlayerPersisted");
    }
}

