/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.mowziesmobs;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class MowzieInvaderProvider
extends InvaderProvider {
    String mod = "mowziesmobs";

    public MowzieInvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Mowzies Mobs Invaders";
    }

    public void generate() {
        this.addBoss("umvuthana", b -> MowzieInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)EntityHandler.UMVUTHANA_MINION.get()).basicData(c -> MowzieInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.FRONTIER, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("umvuthana_raptor", b -> MowzieInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)EntityHandler.UMVUTHANA_RAPTOR.get()).basicData(c -> MowzieInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("umvuthana_crane", b -> MowzieInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)EntityHandler.UMVUTHANA_CRANE.get()).basicData(c -> MowzieInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("naga", b -> MowzieInvaderProvider.basicRangedStats((Invader.Builder)b).entity((EntityType)EntityHandler.NAGA.get()).basicData(c -> MowzieInvaderProvider.rangedGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("umvuthana_raptor", b -> MowzieInvaderProvider.ancientMeleeStats(b).entity((EntityType)EntityHandler.UMVUTHANA_RAPTOR.get()).basicData(c -> MowzieInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("naga", b -> MowzieInvaderProvider.ancientRangedStats(b).entity((EntityType)EntityHandler.NAGA.get()).basicData(c -> MowzieInvaderProvider.rangedGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
    }

    protected static Invader.Builder ancientMeleeStats(Invader.Builder builder) {
        LootRarity ancient = MowzieInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.8f, 1.5f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.2f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected static Invader.Builder ancientRangedStats(Invader.Builder builder) {
        LootRarity ancient = MowzieInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.9f, 1.8f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.0f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected void addBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    protected void addAncientBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/ancient/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

