/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.alexsmods;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import ianm1647.apothic_compats.util.ModTags;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class CavesInvaderProvider
extends InvaderProvider {
    String mod = "alexscaves";

    public CavesInvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Alexs Caves Invaders";
    }

    public void generate() {
        HolderLookup.Provider registries = (HolderLookup.Provider)this.lookupProvider.join();
        HolderLookup.RegistryLookup biomes = (HolderLookup.RegistryLookup)registries.lookup(Registries.BIOME).get();
        this.addBoss("teletor", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.TELETOR.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_MAGNETIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("magnetron", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.MAGNETRON.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_MAGNETIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("ferrouslime", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.FERROUSLIME.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_MAGNETIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("vallumraptor", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.VALLUMRAPTOR.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_PRIMORDIAL_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("grottoceratops", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.GROTTOCERATOPS.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_PRIMORDIAL_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("tremorsaurus", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.TREMORSAURUS.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_PRIMORDIAL_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("brainiac", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.BRAINIAC.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_TOXIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("gammaroach", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.GAMMAROACH.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_TOXIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("gossamer", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.GAMMAROACH.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("deep_one", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.DEEP_ONE.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("deep_one_knight", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.DEEP_ONE_KNIGHT.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("deep_one_mage", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.DEEP_ONE_MAGE.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("underzealot", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.UNDERZEALOT.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_FORLORN_HOLLOWS)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("watcher", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.WATCHER.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.SUMMIT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_FORLORN_HOLLOWS)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("corrodent", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.CORRODENT.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.FRONTIER, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_FORLORN_HOLLOWS)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("caniac", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.CANIAC.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_CANDY_CAVITY)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("gummy_bear", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.GUMMY_BEAR.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.FRONTIER, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_CANDY_CAVITY)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("licowitch", b -> CavesInvaderProvider.basicRangedStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.LICOWITCH.get()).basicData(c -> CavesInvaderProvider.rangedGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_CANDY_CAVITY)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("teletor", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.TELETOR.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_MAGNETIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("magnetron", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.MAGNETRON.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_MAGNETIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("vallumraptor", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.VALLUMRAPTOR.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_PRIMORDIAL_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("tremorsaurus", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.TREMORSAURUS.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_PRIMORDIAL_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("brainiac", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.BRAINIAC.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_TOXIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("tremorzilla", b -> CavesInvaderProvider.ancientMeleeStats(b).entity((EntityType)ACEntityRegistry.TREMORZILLA.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_TOXIC_CAVES)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("deep_one_knight", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.DEEP_ONE_KNIGHT.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("deep_one_mage", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.DEEP_ONE_MAGE.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_ABYSSAL_CHASM)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("watcher", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.WATCHER.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_FORLORN_HOLLOWS)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("forsaken", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.FORSAKEN.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_FORLORN_HOLLOWS)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("caniac", b -> CavesInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.CANIAC.get()).basicData(c -> CavesInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_CANDY_CAVITY)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("licowitch", b -> CavesInvaderProvider.basicRangedStats((Invader.Builder)b).entity((EntityType)ACEntityRegistry.LICOWITCH.get()).basicData(c -> CavesInvaderProvider.rangedGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension((ResourceKey)Level.OVERWORLD)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup)biomes, ModTags.Biomes.IS_CANDY_CAVITY)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
    }

    protected static Invader.Builder ancientMeleeStats(Invader.Builder builder) {
        LootRarity ancient = CavesInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.8f, 1.5f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.2f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected static Invader.Builder ancientRangedStats(Invader.Builder builder) {
        LootRarity ancient = CavesInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.9f, 1.8f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.0f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected void addBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    protected void addAncientBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/ancient/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

