/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.feature;

import com.yungnickyoung.minecraft.ribbits.world.feature.RibbitsVegetationFeatureConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class RibbitsVegetationBlockFeature
extends Feature<RibbitsVegetationFeatureConfig> {
    public RibbitsVegetationBlockFeature() {
        super(RibbitsVegetationFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<RibbitsVegetationFeatureConfig> ctx) {
        WorldGenLevel worldGenLevel = ctx.level();
        BlockPos origin = ctx.origin();
        Optional<BlockStateProvider> onSolidBlockStates = ((RibbitsVegetationFeatureConfig)ctx.config()).onSolidStateProvider();
        List<BlockState> cannotPlaceOn = ((RibbitsVegetationFeatureConfig)ctx.config()).cannotPlaceOn();
        if (cannotPlaceOn.contains(worldGenLevel.getBlockState(origin.below()))) {
            return false;
        }
        if (((RibbitsVegetationFeatureConfig)ctx.config()).onLiquidStateProvider().isPresent() && worldGenLevel.getBlockState(origin.below()).is(Blocks.WATER)) {
            BlockStateProvider onWaterBlockStates = ((RibbitsVegetationFeatureConfig)ctx.config()).onLiquidStateProvider().get();
            worldGenLevel.setBlock(origin, onWaterBlockStates.getState(ctx.random(), origin), 2);
            return true;
        }
        if (onSolidBlockStates.isEmpty()) {
            return false;
        }
        BlockState toPlace = onSolidBlockStates.get().getState(ctx.random(), origin);
        if (toPlace.canSurvive((LevelReader)worldGenLevel, origin)) {
            if (toPlace.getBlock() instanceof DoublePlantBlock) {
                if (!worldGenLevel.isEmptyBlock(origin.above())) {
                    return false;
                }
                DoublePlantBlock.placeAt((LevelAccessor)worldGenLevel, (BlockState)toPlace, (BlockPos)origin, (int)3);
            } else {
                worldGenLevel.setBlock(origin, toPlace, 3);
            }
            return true;
        }
        return false;
    }
}

