/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.food;

import dev.xkmc.arsdelight.content.item.ADFoodBlockItem;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum BlockFoodType {
    FAST(true, false, false, null, ADFoodBlockItem::new),
    FAST_BOWL(true, false, false, () -> Items.BOWL, ADFoodBlockItem::new);

    private final boolean fast;
    private final boolean always;
    private final boolean meat;
    @Nullable
    private final Supplier<Item> container;
    private final Factory factory;

    private BlockFoodType(boolean fast, @Nullable boolean always, boolean meat, Supplier<Item> container, Factory factory) {
        this.fast = fast;
        this.always = always;
        this.meat = meat;
        this.container = container;
        this.factory = factory;
    }

    public ADFoodBlockItem build(Block block, Item.Properties prop, FoodProperties.Builder builder) {
        if (this.fast) {
            builder.fast();
        }
        if (this.always) {
            builder.alwaysEdible();
        }
        prop.food(builder.build());
        if (this.container != null) {
            prop.stacksTo(16);
            prop.craftRemainder(this.container.get());
        }
        return this.factory.create(block, prop, this);
    }

    static interface Factory {
        public ADFoodBlockItem create(Block var1, Item.Properties var2, BlockFoodType var3);
    }
}

