/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.content.jelly;

import dev.xkmc.arsdelight.content.jelly.JellyBlockEntity;
import dev.xkmc.l2modularblock.mult.FallOnBlockMethod;
import dev.xkmc.l2modularblock.mult.SurviveBlockMethod;
import dev.xkmc.l2modularblock.mult.UseWithoutItemBlockMethod;
import dev.xkmc.l2modularblock.one.RenderShapeBlockMethod;
import dev.xkmc.l2modularblock.one.ShapeBlockMethod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public record JellyMethod() implements FallOnBlockMethod,
RenderShapeBlockMethod,
UseWithoutItemBlockMethod,
ShapeBlockMethod,
SurviveBlockMethod
{
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape)Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0));

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public boolean fallOn(Level level, BlockState block, BlockPos pos, Entity entity, float dist) {
        BlockEntity blockEntity;
        if (entity.isSuppressingBounce()) {
            entity.causeFallDamage(dist, 0.2f, entity.damageSources().fall());
        }
        if (dist > 1.0f && (blockEntity = level.getBlockEntity(pos)) instanceof JellyBlockEntity) {
            JellyBlockEntity be = (JellyBlockEntity)blockEntity;
            be.makeWiggle(Direction.UP);
            if (!level.isClientSide() && entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                FoodProperties food = block.getBlock().asItem().getDefaultInstance().getFoodProperties(le);
                if (food != null) {
                    for (FoodProperties.PossibleEffect e : food.effects()) {
                        if (!(e.probability() > le.level().getRandom().nextFloat())) continue;
                        MobEffectInstance eff = e.effect();
                        le.addEffect(new MobEffectInstance(eff.getEffect(), eff.getDuration() / 4, eff.getAmplifier() - 1));
                    }
                }
            }
        }
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof JellyBlockEntity) {
            JellyBlockEntity jelly = (JellyBlockEntity)blockEntity;
            Direction dir = hit.getDirection().getOpposite();
            jelly.makeWiggle(dir);
        }
        return InteractionResult.PASS;
    }
}

