/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.minecraft.forge.math.Vect3d;
import java.util.List;
import net.minecraft.core.Direction;

public interface IWind {
    public Vect3d getMotion();

    default public float getStrengthIn(Direction direction) {
        Direction.Axis axis = direction.getAxis();
        int signum = direction.getAxisDirection().getStep();
        return switch (axis) {
            case Direction.Axis.X -> (float)this.getMotion().x * (float)signum;
            case Direction.Axis.Y -> (float)this.getMotion().y * (float)signum;
            case Direction.Axis.Z -> (float)this.getMotion().z * (float)signum;
            default -> 0.0f;
        };
    }

    default public void sortDirections(List<Direction> directions) {
        directions.sort((dir1, dir2) -> {
            float stren1 = this.getStrengthIn((Direction)dir1);
            float stren2 = this.getStrengthIn((Direction)dir2);
            return Float.compare(stren2, stren1);
        });
    }
}

