/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public abstract class GlassMeter
extends EquipmentItem {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final ChatFormatting nameColor;

    public GlassMeter(UnitConfig config, Properties<?> props) {
        super(config, (EquipmentItem.Properties<?>)props);
        this.nameColor = props.nameColor;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof GlassMeter) {
            BlockState state;
            GlassMeter meter = (GlassMeter)item;
            if (!player.swinging && (state = event.getLevel().getBlockState(event.getPos())).isSolid()) {
                meter.onHit(stack, player);
            }
        }
    }

    protected void onHit(ItemStack stack, Player player) {
        ServerPlayer serverPlayer;
        Level level;
        if (player instanceof ServerPlayer && (level = (serverPlayer = (ServerPlayer)player).level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            GlassMeter.hurtNotDestroy(stack, 1, level2, serverPlayer, item -> level2.playSound(null, player.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public ChatFormatting getNameColor() {
        return this.nameColor;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack)).withStyle(this.getNameColor());
    }

    public static class Properties<T extends Properties<T>>
    extends EquipmentItem.Properties<T> {
        public ChatFormatting nameColor = ChatFormatting.WHITE;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.repairMaterial = UnitId.from("#c:glass_panes");
            this.equipSound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.GLASS_HIT);
        }

        public T nameColor(ChatFormatting nameColor) {
            this.nameColor = nameColor;
            return (T)((Properties)this.self);
        }
    }
}

