/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.units.UnitId;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;

public final class GamePath {
    public static final Path RESOURCES = Paths.get("src/main/resources", new String[0]);
    public static final Path ASSETS = RESOURCES.resolve("assets");
    public static final Path DATA = RESOURCES.resolve("data");
    public static final String DELIMITER = "/";
    public final Path absolute;
    public final ResourceLocation location;
    public final ResourceLocation shortcut;

    private GamePath(Folders root, Folders folder, ResourceLocation regName, Extensions extension, String ... subFolders) {
        String modId = regName.getNamespace();
        String folderName = folder != Folders.NONE && folder != root ? folder.getName() : "";
        String subDir = GamePath.joinPath(subFolders);
        String fullPath = GamePath.joinPath(root.getName(), folderName, subDir, regName.getPath() + extension.getWithDot());
        this.location = ResourceLocation.fromNamespaceAndPath((String)modId, (String)fullPath);
        this.shortcut = ResourceLocation.fromNamespaceAndPath((String)modId, (String)GamePath.joinPath(folderName, subDir, regName.getPath()));
        Path basePath = switch (root.ordinal()) {
            case 9, 13 -> DATA;
            default -> ASSETS;
        };
        this.absolute = Paths.get(basePath.toString(), modId, fullPath).toAbsolutePath();
    }

    public static GamePath model(Folders folder, ResourceLocation regName, String ... subFolders) {
        return new GamePath(Folders.MODELS, folder, regName, Extensions.JSON, subFolders);
    }

    public static GamePath texture(Folders folder, ResourceLocation regName, String ... subFolders) {
        return new GamePath(Folders.TEXTURES, folder, regName, Extensions.PNG, subFolders);
    }

    public static String joinPath(String ... parts) {
        String path = CommonString.Joiner.with(DELIMITER).join(parts);
        String doubleDelimiter = "//";
        while (path.contains(doubleDelimiter)) {
            path = path.replace(doubleDelimiter, DELIMITER);
        }
        return path;
    }

    public static String joinName(String ... words) {
        return UnitId.buildRegName(words);
    }

    public static GamePath armorTexture(ResourceLocation regName) {
        return GamePath.texture(Folders.MODELS, regName, Folders.ARMOR.getName());
    }

    public static GamePath blockState(ResourceLocation regName, String ... subFolders) {
        return new GamePath(Folders.BLOCKSTATES, Folders.BLOCKSTATES, regName, Extensions.JSON, subFolders);
    }

    public static GamePath blockModel(ResourceLocation regName, String ... subFolders) {
        return GamePath.model(Folders.BLOCK, regName, subFolders);
    }

    public static GamePath blockTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.BLOCK, regName, subFolders);
    }

    public static GamePath entityTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.ENTITY, regName, subFolders);
    }

    public static GamePath environmentTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.ENVIRONMENT, regName, subFolders);
    }

    public static GamePath guiTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.GUI, regName, subFolders);
    }

    public static GamePath itemModel(ResourceLocation regName, String ... subFolders) {
        return GamePath.model(Folders.ITEM, regName, subFolders);
    }

    public static GamePath itemTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.ITEM, regName, subFolders);
    }

    public static GamePath langFile(String modId, Locale locale) {
        ResourceLocation regName = ResourceLocation.fromNamespaceAndPath((String)modId, (String)UnitId.buildRegName(locale.getLanguage(), locale.getCountry()));
        return new GamePath(Folders.LANG, Folders.LANG, regName, Extensions.JSON, new String[0]);
    }

    public static GamePath particleTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.PARTICLE, regName, subFolders);
    }

    public static GamePath effectTexture(ResourceLocation regName, String ... subFolders) {
        return GamePath.texture(Folders.POTIONS, regName, subFolders);
    }

    public static GamePath fluidTexture(String modId, String fluidName, boolean flowing, String ... subFolders) {
        String name = GamePath.joinName(fluidName, flowing ? "flow" : "still");
        return GamePath.texture(Folders.FLUIDS, ResourceLocation.fromNamespaceAndPath((String)modId, (String)name), subFolders);
    }

    public static GamePath recipe(ResourceLocation regName, String ... subFolders) {
        return new GamePath(Folders.RECIPES, Folders.RECIPES, regName, Extensions.JSON, subFolders);
    }

    public static GamePath blockLootTable(ResourceLocation regName) {
        return new GamePath(Folders.LOOT_TABLES, Folders.LOOT_TABLES, regName, Extensions.JSON, "blocks");
    }

    public static enum Folders implements IForgeEnum
    {
        ARMOR,
        BLOCK,
        BLOCKSTATES,
        ENTITY,
        ENVIRONMENT,
        FLUIDS,
        ITEM,
        GUI,
        LANG,
        LOOT_TABLES,
        MODELS,
        PARTICLE,
        POTIONS,
        RECIPES,
        TEXTURES,
        NONE;

    }

    public static enum Extensions implements IForgeEnum
    {
        PNG,
        JSON;


        public String getWithDot() {
            return "." + this.getName();
        }
    }
}

