/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<Block, LootTable.Builder> blockLootTables = new ConcurrentHashMap<Block, LootTable.Builder>();
    protected final Map<ResourceLocation, LootTable> customLootTables = new ConcurrentHashMap<ResourceLocation, LootTable>();
    protected final PackOutput.PathProvider pathProvider;
    protected final CompletableFuture<HolderLookup.Provider> registries;

    public BaseLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), VanillaLootTableProvider.create((PackOutput)packOutput, lookupProvider).getTables(), lookupProvider);
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.registries = lookupProvider;
    }

    protected abstract void addTables();

    protected LootPool.Builder blockPool(String name, Block block) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block));
    }

    protected void addBlock(DeferredHolder<Block, ? extends Block> block) {
        this.addBlock(block.getId().getPath(), (Block)block.get());
    }

    protected void addBlock(String name, Block block) {
        this.addBlockPool(block, this.blockPool(name, block));
    }

    protected void addBlockPool(Block block, LootPool.Builder pool) {
        this.blockLootTables.put(block, LootTable.lootTable().withPool(pool));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.addTables();
        HashMap tables = new HashMap();
        this.blockLootTables.forEach((block, builder) -> tables.put(block.getLootTable().location(), builder.setParamSet(LootContextParamSets.BLOCK).build()));
        this.customLootTables.forEach(tables::put);
        return this.registries.thenCompose(provider -> this.writeTables(cache, tables, (HolderLookup.Provider)provider));
    }

    protected CompletableFuture<?> writeTables(CachedOutput cache, Map<ResourceLocation, LootTable> tables, HolderLookup.Provider provider) {
        return CompletableFuture.allOf((CompletableFuture[])tables.entrySet().stream().map(entry -> {
            Path path = this.pathProvider.json((ResourceLocation)entry.getKey());
            LootTable lootTable = (LootTable)entry.getValue();
            return DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)LootTable.DIRECT_CODEC, (Object)lootTable, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

